/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotfleetwise.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotfleetwise.model.transform.CanDbcDefinitionMarshaller;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CanDbcDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String networkInterface;
    private List<ByteBuffer> canDbcFiles;
    private Map<String, String> signalsMap;

    public void setNetworkInterface(String networkInterface) {
        this.networkInterface = networkInterface;
    }

    public String getNetworkInterface() {
        return this.networkInterface;
    }

    public CanDbcDefinition withNetworkInterface(String networkInterface) {
        this.setNetworkInterface(networkInterface);
        return this;
    }

    public List<ByteBuffer> getCanDbcFiles() {
        return this.canDbcFiles;
    }

    public void setCanDbcFiles(Collection<ByteBuffer> canDbcFiles) {
        if (canDbcFiles == null) {
            this.canDbcFiles = null;
            return;
        }
        this.canDbcFiles = new ArrayList<ByteBuffer>(canDbcFiles);
    }

    public CanDbcDefinition withCanDbcFiles(ByteBuffer ... canDbcFiles) {
        if (this.canDbcFiles == null) {
            this.setCanDbcFiles(new ArrayList<ByteBuffer>(canDbcFiles.length));
        }
        for (ByteBuffer ele : canDbcFiles) {
            this.canDbcFiles.add(ele);
        }
        return this;
    }

    public CanDbcDefinition withCanDbcFiles(Collection<ByteBuffer> canDbcFiles) {
        this.setCanDbcFiles(canDbcFiles);
        return this;
    }

    public Map<String, String> getSignalsMap() {
        return this.signalsMap;
    }

    public void setSignalsMap(Map<String, String> signalsMap) {
        this.signalsMap = signalsMap;
    }

    public CanDbcDefinition withSignalsMap(Map<String, String> signalsMap) {
        this.setSignalsMap(signalsMap);
        return this;
    }

    public CanDbcDefinition addSignalsMapEntry(String key, String value) {
        if (null == this.signalsMap) {
            this.signalsMap = new HashMap<String, String>();
        }
        if (this.signalsMap.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.signalsMap.put(key, value);
        return this;
    }

    public CanDbcDefinition clearSignalsMapEntries() {
        this.signalsMap = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNetworkInterface() != null) {
            sb.append("NetworkInterface: ").append(this.getNetworkInterface()).append(",");
        }
        if (this.getCanDbcFiles() != null) {
            sb.append("CanDbcFiles: ").append(this.getCanDbcFiles()).append(",");
        }
        if (this.getSignalsMap() != null) {
            sb.append("SignalsMap: ").append(this.getSignalsMap());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CanDbcDefinition)) {
            return false;
        }
        CanDbcDefinition other = (CanDbcDefinition)obj;
        if (other.getNetworkInterface() == null ^ this.getNetworkInterface() == null) {
            return false;
        }
        if (other.getNetworkInterface() != null && !other.getNetworkInterface().equals(this.getNetworkInterface())) {
            return false;
        }
        if (other.getCanDbcFiles() == null ^ this.getCanDbcFiles() == null) {
            return false;
        }
        if (other.getCanDbcFiles() != null && !other.getCanDbcFiles().equals(this.getCanDbcFiles())) {
            return false;
        }
        if (other.getSignalsMap() == null ^ this.getSignalsMap() == null) {
            return false;
        }
        return other.getSignalsMap() == null || other.getSignalsMap().equals(this.getSignalsMap());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNetworkInterface() == null ? 0 : this.getNetworkInterface().hashCode());
        hashCode = 31 * hashCode + (this.getCanDbcFiles() == null ? 0 : this.getCanDbcFiles().hashCode());
        hashCode = 31 * hashCode + (this.getSignalsMap() == null ? 0 : this.getSignalsMap().hashCode());
        return hashCode;
    }

    public CanDbcDefinition clone() {
        try {
            return (CanDbcDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CanDbcDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

