/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ioteventsdata.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ioteventsdata.model.TimerDefinition;
import com.amazonaws.services.ioteventsdata.model.VariableDefinition;
import com.amazonaws.services.ioteventsdata.model.transform.DetectorStateDefinitionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DetectorStateDefinition
implements Serializable,
Cloneable,
StructuredPojo {
    private String stateName;
    private List<VariableDefinition> variables;
    private List<TimerDefinition> timers;

    public void setStateName(String stateName) {
        this.stateName = stateName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public DetectorStateDefinition withStateName(String stateName) {
        this.setStateName(stateName);
        return this;
    }

    public List<VariableDefinition> getVariables() {
        return this.variables;
    }

    public void setVariables(Collection<VariableDefinition> variables) {
        if (variables == null) {
            this.variables = null;
            return;
        }
        this.variables = new ArrayList<VariableDefinition>(variables);
    }

    public DetectorStateDefinition withVariables(VariableDefinition ... variables) {
        if (this.variables == null) {
            this.setVariables(new ArrayList<VariableDefinition>(variables.length));
        }
        for (VariableDefinition ele : variables) {
            this.variables.add(ele);
        }
        return this;
    }

    public DetectorStateDefinition withVariables(Collection<VariableDefinition> variables) {
        this.setVariables(variables);
        return this;
    }

    public List<TimerDefinition> getTimers() {
        return this.timers;
    }

    public void setTimers(Collection<TimerDefinition> timers) {
        if (timers == null) {
            this.timers = null;
            return;
        }
        this.timers = new ArrayList<TimerDefinition>(timers);
    }

    public DetectorStateDefinition withTimers(TimerDefinition ... timers) {
        if (this.timers == null) {
            this.setTimers(new ArrayList<TimerDefinition>(timers.length));
        }
        for (TimerDefinition ele : timers) {
            this.timers.add(ele);
        }
        return this;
    }

    public DetectorStateDefinition withTimers(Collection<TimerDefinition> timers) {
        this.setTimers(timers);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStateName() != null) {
            sb.append("StateName: ").append(this.getStateName()).append(",");
        }
        if (this.getVariables() != null) {
            sb.append("Variables: ").append(this.getVariables()).append(",");
        }
        if (this.getTimers() != null) {
            sb.append("Timers: ").append(this.getTimers());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DetectorStateDefinition)) {
            return false;
        }
        DetectorStateDefinition other = (DetectorStateDefinition)obj;
        if (other.getStateName() == null ^ this.getStateName() == null) {
            return false;
        }
        if (other.getStateName() != null && !other.getStateName().equals(this.getStateName())) {
            return false;
        }
        if (other.getVariables() == null ^ this.getVariables() == null) {
            return false;
        }
        if (other.getVariables() != null && !other.getVariables().equals(this.getVariables())) {
            return false;
        }
        if (other.getTimers() == null ^ this.getTimers() == null) {
            return false;
        }
        return other.getTimers() == null || other.getTimers().equals(this.getTimers());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStateName() == null ? 0 : this.getStateName().hashCode());
        hashCode = 31 * hashCode + (this.getVariables() == null ? 0 : this.getVariables().hashCode());
        hashCode = 31 * hashCode + (this.getTimers() == null ? 0 : this.getTimers().hashCode());
        return hashCode;
    }

    public DetectorStateDefinition clone() {
        try {
            return (DetectorStateDefinition)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DetectorStateDefinitionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

