/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iotevents.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.iotevents.model.EmailConfiguration;
import com.amazonaws.services.iotevents.model.NotificationTargetActions;
import com.amazonaws.services.iotevents.model.SMSConfiguration;
import com.amazonaws.services.iotevents.model.transform.NotificationActionMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NotificationAction
implements Serializable,
Cloneable,
StructuredPojo {
    private NotificationTargetActions action;
    private List<SMSConfiguration> smsConfigurations;
    private List<EmailConfiguration> emailConfigurations;

    public void setAction(NotificationTargetActions action) {
        this.action = action;
    }

    public NotificationTargetActions getAction() {
        return this.action;
    }

    public NotificationAction withAction(NotificationTargetActions action) {
        this.setAction(action);
        return this;
    }

    public List<SMSConfiguration> getSmsConfigurations() {
        return this.smsConfigurations;
    }

    public void setSmsConfigurations(Collection<SMSConfiguration> smsConfigurations) {
        if (smsConfigurations == null) {
            this.smsConfigurations = null;
            return;
        }
        this.smsConfigurations = new ArrayList<SMSConfiguration>(smsConfigurations);
    }

    public NotificationAction withSmsConfigurations(SMSConfiguration ... smsConfigurations) {
        if (this.smsConfigurations == null) {
            this.setSmsConfigurations(new ArrayList<SMSConfiguration>(smsConfigurations.length));
        }
        for (SMSConfiguration ele : smsConfigurations) {
            this.smsConfigurations.add(ele);
        }
        return this;
    }

    public NotificationAction withSmsConfigurations(Collection<SMSConfiguration> smsConfigurations) {
        this.setSmsConfigurations(smsConfigurations);
        return this;
    }

    public List<EmailConfiguration> getEmailConfigurations() {
        return this.emailConfigurations;
    }

    public void setEmailConfigurations(Collection<EmailConfiguration> emailConfigurations) {
        if (emailConfigurations == null) {
            this.emailConfigurations = null;
            return;
        }
        this.emailConfigurations = new ArrayList<EmailConfiguration>(emailConfigurations);
    }

    public NotificationAction withEmailConfigurations(EmailConfiguration ... emailConfigurations) {
        if (this.emailConfigurations == null) {
            this.setEmailConfigurations(new ArrayList<EmailConfiguration>(emailConfigurations.length));
        }
        for (EmailConfiguration ele : emailConfigurations) {
            this.emailConfigurations.add(ele);
        }
        return this;
    }

    public NotificationAction withEmailConfigurations(Collection<EmailConfiguration> emailConfigurations) {
        this.setEmailConfigurations(emailConfigurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAction() != null) {
            sb.append("Action: ").append(this.getAction()).append(",");
        }
        if (this.getSmsConfigurations() != null) {
            sb.append("SmsConfigurations: ").append(this.getSmsConfigurations()).append(",");
        }
        if (this.getEmailConfigurations() != null) {
            sb.append("EmailConfigurations: ").append(this.getEmailConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotificationAction)) {
            return false;
        }
        NotificationAction other = (NotificationAction)obj;
        if (other.getAction() == null ^ this.getAction() == null) {
            return false;
        }
        if (other.getAction() != null && !other.getAction().equals(this.getAction())) {
            return false;
        }
        if (other.getSmsConfigurations() == null ^ this.getSmsConfigurations() == null) {
            return false;
        }
        if (other.getSmsConfigurations() != null && !other.getSmsConfigurations().equals(this.getSmsConfigurations())) {
            return false;
        }
        if (other.getEmailConfigurations() == null ^ this.getEmailConfigurations() == null) {
            return false;
        }
        return other.getEmailConfigurations() == null || other.getEmailConfigurations().equals(this.getEmailConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAction() == null ? 0 : this.getAction().hashCode());
        hashCode = 31 * hashCode + (this.getSmsConfigurations() == null ? 0 : this.getSmsConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getEmailConfigurations() == null ? 0 : this.getEmailConfigurations().hashCode());
        return hashCode;
    }

    public NotificationAction clone() {
        try {
            return (NotificationAction)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        NotificationActionMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

