/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CreatePackageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String packageName;
    private String description;
    private Map<String, String> tags;
    private String clientToken;

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public CreatePackageRequest withPackageName(String packageName) {
        this.setPackageName(packageName);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreatePackageRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreatePackageRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreatePackageRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreatePackageRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreatePackageRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPackageName() != null) {
            sb.append("PackageName: ").append(this.getPackageName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePackageRequest)) {
            return false;
        }
        CreatePackageRequest other = (CreatePackageRequest)obj;
        if (other.getPackageName() == null ^ this.getPackageName() == null) {
            return false;
        }
        if (other.getPackageName() != null && !other.getPackageName().equals(this.getPackageName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPackageName() == null ? 0 : this.getPackageName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public CreatePackageRequest clone() {
        return (CreatePackageRequest)super.clone();
    }
}

