/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.internetmonitor.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.internetmonitor.model.InternetMeasurementsLogDelivery;
import com.amazonaws.services.internetmonitor.model.MonitorConfigState;
import com.amazonaws.services.internetmonitor.model.MonitorProcessingStatusCode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetMonitorResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String monitorName;
    private String monitorArn;
    private List<String> resources;
    private String status;
    private Date createdAt;
    private Date modifiedAt;
    private String processingStatus;
    private String processingStatusInfo;
    private Map<String, String> tags;
    private Integer maxCityNetworksToMonitor;
    private InternetMeasurementsLogDelivery internetMeasurementsLogDelivery;
    private Integer trafficPercentageToMonitor;

    public void setMonitorName(String monitorName) {
        this.monitorName = monitorName;
    }

    public String getMonitorName() {
        return this.monitorName;
    }

    public GetMonitorResult withMonitorName(String monitorName) {
        this.setMonitorName(monitorName);
        return this;
    }

    public void setMonitorArn(String monitorArn) {
        this.monitorArn = monitorArn;
    }

    public String getMonitorArn() {
        return this.monitorArn;
    }

    public GetMonitorResult withMonitorArn(String monitorArn) {
        this.setMonitorArn(monitorArn);
        return this;
    }

    public List<String> getResources() {
        return this.resources;
    }

    public void setResources(Collection<String> resources) {
        if (resources == null) {
            this.resources = null;
            return;
        }
        this.resources = new ArrayList<String>(resources);
    }

    public GetMonitorResult withResources(String ... resources) {
        if (this.resources == null) {
            this.setResources(new ArrayList<String>(resources.length));
        }
        for (String ele : resources) {
            this.resources.add(ele);
        }
        return this;
    }

    public GetMonitorResult withResources(Collection<String> resources) {
        this.setResources(resources);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public GetMonitorResult withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public GetMonitorResult withStatus(MonitorConfigState status) {
        this.status = status.toString();
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public GetMonitorResult withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public GetMonitorResult withModifiedAt(Date modifiedAt) {
        this.setModifiedAt(modifiedAt);
        return this;
    }

    public void setProcessingStatus(String processingStatus) {
        this.processingStatus = processingStatus;
    }

    public String getProcessingStatus() {
        return this.processingStatus;
    }

    public GetMonitorResult withProcessingStatus(String processingStatus) {
        this.setProcessingStatus(processingStatus);
        return this;
    }

    public GetMonitorResult withProcessingStatus(MonitorProcessingStatusCode processingStatus) {
        this.processingStatus = processingStatus.toString();
        return this;
    }

    public void setProcessingStatusInfo(String processingStatusInfo) {
        this.processingStatusInfo = processingStatusInfo;
    }

    public String getProcessingStatusInfo() {
        return this.processingStatusInfo;
    }

    public GetMonitorResult withProcessingStatusInfo(String processingStatusInfo) {
        this.setProcessingStatusInfo(processingStatusInfo);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public GetMonitorResult withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public GetMonitorResult addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public GetMonitorResult clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setMaxCityNetworksToMonitor(Integer maxCityNetworksToMonitor) {
        this.maxCityNetworksToMonitor = maxCityNetworksToMonitor;
    }

    public Integer getMaxCityNetworksToMonitor() {
        return this.maxCityNetworksToMonitor;
    }

    public GetMonitorResult withMaxCityNetworksToMonitor(Integer maxCityNetworksToMonitor) {
        this.setMaxCityNetworksToMonitor(maxCityNetworksToMonitor);
        return this;
    }

    public void setInternetMeasurementsLogDelivery(InternetMeasurementsLogDelivery internetMeasurementsLogDelivery) {
        this.internetMeasurementsLogDelivery = internetMeasurementsLogDelivery;
    }

    public InternetMeasurementsLogDelivery getInternetMeasurementsLogDelivery() {
        return this.internetMeasurementsLogDelivery;
    }

    public GetMonitorResult withInternetMeasurementsLogDelivery(InternetMeasurementsLogDelivery internetMeasurementsLogDelivery) {
        this.setInternetMeasurementsLogDelivery(internetMeasurementsLogDelivery);
        return this;
    }

    public void setTrafficPercentageToMonitor(Integer trafficPercentageToMonitor) {
        this.trafficPercentageToMonitor = trafficPercentageToMonitor;
    }

    public Integer getTrafficPercentageToMonitor() {
        return this.trafficPercentageToMonitor;
    }

    public GetMonitorResult withTrafficPercentageToMonitor(Integer trafficPercentageToMonitor) {
        this.setTrafficPercentageToMonitor(trafficPercentageToMonitor);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMonitorName() != null) {
            sb.append("MonitorName: ").append(this.getMonitorName()).append(",");
        }
        if (this.getMonitorArn() != null) {
            sb.append("MonitorArn: ").append(this.getMonitorArn()).append(",");
        }
        if (this.getResources() != null) {
            sb.append("Resources: ").append(this.getResources()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getModifiedAt() != null) {
            sb.append("ModifiedAt: ").append(this.getModifiedAt()).append(",");
        }
        if (this.getProcessingStatus() != null) {
            sb.append("ProcessingStatus: ").append(this.getProcessingStatus()).append(",");
        }
        if (this.getProcessingStatusInfo() != null) {
            sb.append("ProcessingStatusInfo: ").append(this.getProcessingStatusInfo()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getMaxCityNetworksToMonitor() != null) {
            sb.append("MaxCityNetworksToMonitor: ").append(this.getMaxCityNetworksToMonitor()).append(",");
        }
        if (this.getInternetMeasurementsLogDelivery() != null) {
            sb.append("InternetMeasurementsLogDelivery: ").append(this.getInternetMeasurementsLogDelivery()).append(",");
        }
        if (this.getTrafficPercentageToMonitor() != null) {
            sb.append("TrafficPercentageToMonitor: ").append(this.getTrafficPercentageToMonitor());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMonitorResult)) {
            return false;
        }
        GetMonitorResult other = (GetMonitorResult)obj;
        if (other.getMonitorName() == null ^ this.getMonitorName() == null) {
            return false;
        }
        if (other.getMonitorName() != null && !other.getMonitorName().equals(this.getMonitorName())) {
            return false;
        }
        if (other.getMonitorArn() == null ^ this.getMonitorArn() == null) {
            return false;
        }
        if (other.getMonitorArn() != null && !other.getMonitorArn().equals(this.getMonitorArn())) {
            return false;
        }
        if (other.getResources() == null ^ this.getResources() == null) {
            return false;
        }
        if (other.getResources() != null && !other.getResources().equals(this.getResources())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getModifiedAt() == null ^ this.getModifiedAt() == null) {
            return false;
        }
        if (other.getModifiedAt() != null && !other.getModifiedAt().equals(this.getModifiedAt())) {
            return false;
        }
        if (other.getProcessingStatus() == null ^ this.getProcessingStatus() == null) {
            return false;
        }
        if (other.getProcessingStatus() != null && !other.getProcessingStatus().equals(this.getProcessingStatus())) {
            return false;
        }
        if (other.getProcessingStatusInfo() == null ^ this.getProcessingStatusInfo() == null) {
            return false;
        }
        if (other.getProcessingStatusInfo() != null && !other.getProcessingStatusInfo().equals(this.getProcessingStatusInfo())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getMaxCityNetworksToMonitor() == null ^ this.getMaxCityNetworksToMonitor() == null) {
            return false;
        }
        if (other.getMaxCityNetworksToMonitor() != null && !other.getMaxCityNetworksToMonitor().equals(this.getMaxCityNetworksToMonitor())) {
            return false;
        }
        if (other.getInternetMeasurementsLogDelivery() == null ^ this.getInternetMeasurementsLogDelivery() == null) {
            return false;
        }
        if (other.getInternetMeasurementsLogDelivery() != null && !other.getInternetMeasurementsLogDelivery().equals(this.getInternetMeasurementsLogDelivery())) {
            return false;
        }
        if (other.getTrafficPercentageToMonitor() == null ^ this.getTrafficPercentageToMonitor() == null) {
            return false;
        }
        return other.getTrafficPercentageToMonitor() == null || other.getTrafficPercentageToMonitor().equals(this.getTrafficPercentageToMonitor());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMonitorName() == null ? 0 : this.getMonitorName().hashCode());
        hashCode = 31 * hashCode + (this.getMonitorArn() == null ? 0 : this.getMonitorArn().hashCode());
        hashCode = 31 * hashCode + (this.getResources() == null ? 0 : this.getResources().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getModifiedAt() == null ? 0 : this.getModifiedAt().hashCode());
        hashCode = 31 * hashCode + (this.getProcessingStatus() == null ? 0 : this.getProcessingStatus().hashCode());
        hashCode = 31 * hashCode + (this.getProcessingStatusInfo() == null ? 0 : this.getProcessingStatusInfo().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getMaxCityNetworksToMonitor() == null ? 0 : this.getMaxCityNetworksToMonitor().hashCode());
        hashCode = 31 * hashCode + (this.getInternetMeasurementsLogDelivery() == null ? 0 : this.getInternetMeasurementsLogDelivery().hashCode());
        hashCode = 31 * hashCode + (this.getTrafficPercentageToMonitor() == null ? 0 : this.getTrafficPercentageToMonitor().hashCode());
        return hashCode;
    }

    public GetMonitorResult clone() {
        try {
            return (GetMonitorResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

