/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.inspector2.model.Vulnerability;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class VulnerabilityMarshaller {
    private static final MarshallingInfo<StructuredPojo> ATIGDATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("atigData").build();
    private static final MarshallingInfo<StructuredPojo> CISADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cisaData").build();
    private static final MarshallingInfo<StructuredPojo> CVSS2_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cvss2").build();
    private static final MarshallingInfo<StructuredPojo> CVSS3_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cvss3").build();
    private static final MarshallingInfo<List> CWES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("cwes").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<List> DETECTIONPLATFORMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("detectionPlatforms").build();
    private static final MarshallingInfo<StructuredPojo> EPSS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("epss").build();
    private static final MarshallingInfo<StructuredPojo> EXPLOITOBSERVED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("exploitObserved").build();
    private static final MarshallingInfo<String> ID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("id").build();
    private static final MarshallingInfo<List> REFERENCEURLS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("referenceUrls").build();
    private static final MarshallingInfo<List> RELATEDVULNERABILITIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("relatedVulnerabilities").build();
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").build();
    private static final MarshallingInfo<String> SOURCEURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("sourceUrl").build();
    private static final MarshallingInfo<Date> VENDORCREATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vendorCreatedAt").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> VENDORSEVERITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vendorSeverity").build();
    private static final MarshallingInfo<Date> VENDORUPDATEDAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vendorUpdatedAt").timestampFormat("unixTimestamp").build();
    private static final VulnerabilityMarshaller instance = new VulnerabilityMarshaller();

    public static VulnerabilityMarshaller getInstance() {
        return instance;
    }

    public void marshall(Vulnerability vulnerability, ProtocolMarshaller protocolMarshaller) {
        if (vulnerability == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)vulnerability.getAtigData(), ATIGDATA_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getCisaData(), CISADATA_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getCvss2(), CVSS2_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getCvss3(), CVSS3_BINDING);
            protocolMarshaller.marshall(vulnerability.getCwes(), CWES_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(vulnerability.getDetectionPlatforms(), DETECTIONPLATFORMS_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getEpss(), EPSS_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getExploitObserved(), EXPLOITOBSERVED_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getId(), ID_BINDING);
            protocolMarshaller.marshall(vulnerability.getReferenceUrls(), REFERENCEURLS_BINDING);
            protocolMarshaller.marshall(vulnerability.getRelatedVulnerabilities(), RELATEDVULNERABILITIES_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getSource(), SOURCE_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getSourceUrl(), SOURCEURL_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getVendorCreatedAt(), VENDORCREATEDAT_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getVendorSeverity(), VENDORSEVERITY_BINDING);
            protocolMarshaller.marshall((Object)vulnerability.getVendorUpdatedAt(), VENDORUPDATEDAT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

