/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.inspector2.model.CodeFilePath;

@SdkInternalApi
public class CodeFilePathMarshaller {
    private static final MarshallingInfo<Integer> ENDLINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("endLine").build();
    private static final MarshallingInfo<String> FILENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("fileName").build();
    private static final MarshallingInfo<String> FILEPATH_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("filePath").build();
    private static final MarshallingInfo<Integer> STARTLINE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("startLine").build();
    private static final CodeFilePathMarshaller instance = new CodeFilePathMarshaller();

    public static CodeFilePathMarshaller getInstance() {
        return instance;
    }

    public void marshall(CodeFilePath codeFilePath, ProtocolMarshaller protocolMarshaller) {
        if (codeFilePath == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)codeFilePath.getEndLine(), ENDLINE_BINDING);
            protocolMarshaller.marshall((Object)codeFilePath.getFileName(), FILENAME_BINDING);
            protocolMarshaller.marshall((Object)codeFilePath.getFilePath(), FILEPATH_BINDING);
            protocolMarshaller.marshall((Object)codeFilePath.getStartLine(), STARTLINE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

