/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector2.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.inspector2.model.CisaData;
import java.util.Date;

@SdkInternalApi
public class CisaDataMarshaller {
    private static final MarshallingInfo<String> ACTION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("action").build();
    private static final MarshallingInfo<Date> DATEADDED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dateAdded").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> DATEDUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("dateDue").timestampFormat("unixTimestamp").build();
    private static final CisaDataMarshaller instance = new CisaDataMarshaller();

    public static CisaDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(CisaData cisaData, ProtocolMarshaller protocolMarshaller) {
        if (cisaData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cisaData.getAction(), ACTION_BINDING);
            protocolMarshaller.marshall((Object)cisaData.getDateAdded(), DATEADDED_BINDING);
            protocolMarshaller.marshall((Object)cisaData.getDateDue(), DATEDUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

