/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.inspector.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.inspector.model.AssetAttributes;
import java.util.List;

@SdkInternalApi
public class AssetAttributesMarshaller {
    private static final MarshallingInfo<Integer> SCHEMAVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("schemaVersion").build();
    private static final MarshallingInfo<String> AGENTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("agentId").build();
    private static final MarshallingInfo<String> AUTOSCALINGGROUP_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("autoScalingGroup").build();
    private static final MarshallingInfo<String> AMIID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("amiId").build();
    private static final MarshallingInfo<String> HOSTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("hostname").build();
    private static final MarshallingInfo<List> IPV4ADDRESSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ipv4Addresses").build();
    private static final AssetAttributesMarshaller instance = new AssetAttributesMarshaller();

    public static AssetAttributesMarshaller getInstance() {
        return instance;
    }

    public void marshall(AssetAttributes assetAttributes, ProtocolMarshaller protocolMarshaller) {
        if (assetAttributes == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)assetAttributes.getSchemaVersion(), SCHEMAVERSION_BINDING);
            protocolMarshaller.marshall((Object)assetAttributes.getAgentId(), AGENTID_BINDING);
            protocolMarshaller.marshall((Object)assetAttributes.getAutoScalingGroup(), AUTOSCALINGGROUP_BINDING);
            protocolMarshaller.marshall((Object)assetAttributes.getAmiId(), AMIID_BINDING);
            protocolMarshaller.marshall((Object)assetAttributes.getHostname(), HOSTNAME_BINDING);
            protocolMarshaller.marshall(assetAttributes.getIpv4Addresses(), IPV4ADDRESSES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

