/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.imagebuilder.model.CvssScore;

@SdkInternalApi
public class CvssScoreMarshaller {
    private static final MarshallingInfo<Double> BASESCORE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("baseScore").build();
    private static final MarshallingInfo<String> SCORINGVECTOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("scoringVector").build();
    private static final MarshallingInfo<String> VERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("version").build();
    private static final MarshallingInfo<String> SOURCE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("source").build();
    private static final CvssScoreMarshaller instance = new CvssScoreMarshaller();

    public static CvssScoreMarshaller getInstance() {
        return instance;
    }

    public void marshall(CvssScore cvssScore, ProtocolMarshaller protocolMarshaller) {
        if (cvssScore == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cvssScore.getBaseScore(), BASESCORE_BINDING);
            protocolMarshaller.marshall((Object)cvssScore.getScoringVector(), SCORINGVECTOR_BINDING);
            protocolMarshaller.marshall((Object)cvssScore.getVersion(), VERSION_BINDING);
            protocolMarshaller.marshall((Object)cvssScore.getSource(), SOURCE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

