/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.imagebuilder.model.S3ExportConfiguration;

@SdkInternalApi
public class S3ExportConfigurationMarshaller {
    private static final MarshallingInfo<String> ROLENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleName").build();
    private static final MarshallingInfo<String> DISKIMAGEFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("diskImageFormat").build();
    private static final MarshallingInfo<String> S3BUCKET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Bucket").build();
    private static final MarshallingInfo<String> S3PREFIX_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("s3Prefix").build();
    private static final S3ExportConfigurationMarshaller instance = new S3ExportConfigurationMarshaller();

    public static S3ExportConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(S3ExportConfiguration s3ExportConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (s3ExportConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)s3ExportConfiguration.getRoleName(), ROLENAME_BINDING);
            protocolMarshaller.marshall((Object)s3ExportConfiguration.getDiskImageFormat(), DISKIMAGEFORMAT_BINDING);
            protocolMarshaller.marshall((Object)s3ExportConfiguration.getS3Bucket(), S3BUCKET_BINDING);
            protocolMarshaller.marshall((Object)s3ExportConfiguration.getS3Prefix(), S3PREFIX_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

