/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.imagebuilder.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.imagebuilder.model.InstanceConfiguration;
import java.util.List;

@SdkInternalApi
public class InstanceConfigurationMarshaller {
    private static final MarshallingInfo<String> IMAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("image").build();
    private static final MarshallingInfo<List> BLOCKDEVICEMAPPINGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("blockDeviceMappings").build();
    private static final InstanceConfigurationMarshaller instance = new InstanceConfigurationMarshaller();

    public static InstanceConfigurationMarshaller getInstance() {
        return instance;
    }

    public void marshall(InstanceConfiguration instanceConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (instanceConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceConfiguration.getImage(), IMAGE_BINDING);
            protocolMarshaller.marshall(instanceConfiguration.getBlockDeviceMappings(), BLOCKDEVICEMAPPINGS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

