/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.identitymanagement.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.identitymanagement.model.ContextEntry;
import com.amazonaws.services.identitymanagement.model.SimulatePrincipalPolicyRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SimulatePrincipalPolicyRequestMarshaller
implements Marshaller<Request<SimulatePrincipalPolicyRequest>, SimulatePrincipalPolicyRequest> {
    public Request<SimulatePrincipalPolicyRequest> marshall(SimulatePrincipalPolicyRequest simulatePrincipalPolicyRequest) {
        if (simulatePrincipalPolicyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)simulatePrincipalPolicyRequest, "AmazonIdentityManagement");
        request.addParameter("Action", "SimulatePrincipalPolicy");
        request.addParameter("Version", "2010-05-08");
        request.setHttpMethod(HttpMethodName.POST);
        if (simulatePrincipalPolicyRequest.getPolicySourceArn() != null) {
            request.addParameter("PolicySourceArn", StringUtils.fromString((String)simulatePrincipalPolicyRequest.getPolicySourceArn()));
        }
        if (!simulatePrincipalPolicyRequest.getPolicyInputList().isEmpty() || !((SdkInternalList)simulatePrincipalPolicyRequest.getPolicyInputList()).isAutoConstruct()) {
            SdkInternalList policyInputListList = (SdkInternalList)simulatePrincipalPolicyRequest.getPolicyInputList();
            int policyInputListListIndex = 1;
            for (String policyInputListListValue : policyInputListList) {
                if (policyInputListListValue != null) {
                    request.addParameter("PolicyInputList.member." + policyInputListListIndex, StringUtils.fromString((String)policyInputListListValue));
                }
                ++policyInputListListIndex;
            }
        }
        if (!simulatePrincipalPolicyRequest.getPermissionsBoundaryPolicyInputList().isEmpty() || !((SdkInternalList)simulatePrincipalPolicyRequest.getPermissionsBoundaryPolicyInputList()).isAutoConstruct()) {
            SdkInternalList permissionsBoundaryPolicyInputListList = (SdkInternalList)simulatePrincipalPolicyRequest.getPermissionsBoundaryPolicyInputList();
            int permissionsBoundaryPolicyInputListListIndex = 1;
            for (String permissionsBoundaryPolicyInputListListValue : permissionsBoundaryPolicyInputListList) {
                if (permissionsBoundaryPolicyInputListListValue != null) {
                    request.addParameter("PermissionsBoundaryPolicyInputList.member." + permissionsBoundaryPolicyInputListListIndex, StringUtils.fromString((String)permissionsBoundaryPolicyInputListListValue));
                }
                ++permissionsBoundaryPolicyInputListListIndex;
            }
        }
        if (!simulatePrincipalPolicyRequest.getActionNames().isEmpty() || !((SdkInternalList)simulatePrincipalPolicyRequest.getActionNames()).isAutoConstruct()) {
            SdkInternalList actionNamesList = (SdkInternalList)simulatePrincipalPolicyRequest.getActionNames();
            int actionNamesListIndex = 1;
            for (String actionNamesListValue : actionNamesList) {
                if (actionNamesListValue != null) {
                    request.addParameter("ActionNames.member." + actionNamesListIndex, StringUtils.fromString((String)actionNamesListValue));
                }
                ++actionNamesListIndex;
            }
        }
        if (!simulatePrincipalPolicyRequest.getResourceArns().isEmpty() || !((SdkInternalList)simulatePrincipalPolicyRequest.getResourceArns()).isAutoConstruct()) {
            SdkInternalList resourceArnsList = (SdkInternalList)simulatePrincipalPolicyRequest.getResourceArns();
            int resourceArnsListIndex = 1;
            for (String resourceArnsListValue : resourceArnsList) {
                if (resourceArnsListValue != null) {
                    request.addParameter("ResourceArns.member." + resourceArnsListIndex, StringUtils.fromString((String)resourceArnsListValue));
                }
                ++resourceArnsListIndex;
            }
        }
        if (simulatePrincipalPolicyRequest.getResourcePolicy() != null) {
            request.addParameter("ResourcePolicy", StringUtils.fromString((String)simulatePrincipalPolicyRequest.getResourcePolicy()));
        }
        if (simulatePrincipalPolicyRequest.getResourceOwner() != null) {
            request.addParameter("ResourceOwner", StringUtils.fromString((String)simulatePrincipalPolicyRequest.getResourceOwner()));
        }
        if (simulatePrincipalPolicyRequest.getCallerArn() != null) {
            request.addParameter("CallerArn", StringUtils.fromString((String)simulatePrincipalPolicyRequest.getCallerArn()));
        }
        if (!simulatePrincipalPolicyRequest.getContextEntries().isEmpty() || !((SdkInternalList)simulatePrincipalPolicyRequest.getContextEntries()).isAutoConstruct()) {
            SdkInternalList contextEntriesList = (SdkInternalList)simulatePrincipalPolicyRequest.getContextEntries();
            int contextEntriesListIndex = 1;
            for (ContextEntry contextEntriesListValue : contextEntriesList) {
                if (contextEntriesListValue != null) {
                    if (contextEntriesListValue.getContextKeyName() != null) {
                        request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyName", StringUtils.fromString((String)contextEntriesListValue.getContextKeyName()));
                    }
                    if (!contextEntriesListValue.getContextKeyValues().isEmpty() || !((SdkInternalList)contextEntriesListValue.getContextKeyValues()).isAutoConstruct()) {
                        SdkInternalList contextKeyValuesList = (SdkInternalList)contextEntriesListValue.getContextKeyValues();
                        int contextKeyValuesListIndex = 1;
                        for (String contextKeyValuesListValue : contextKeyValuesList) {
                            if (contextKeyValuesListValue != null) {
                                request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyValues.member." + contextKeyValuesListIndex, StringUtils.fromString((String)contextKeyValuesListValue));
                            }
                            ++contextKeyValuesListIndex;
                        }
                    }
                    if (contextEntriesListValue.getContextKeyType() != null) {
                        request.addParameter("ContextEntries.member." + contextEntriesListIndex + ".ContextKeyType", StringUtils.fromString((String)contextEntriesListValue.getContextKeyType()));
                    }
                }
                ++contextEntriesListIndex;
            }
        }
        if (simulatePrincipalPolicyRequest.getResourceHandlingOption() != null) {
            request.addParameter("ResourceHandlingOption", StringUtils.fromString((String)simulatePrincipalPolicyRequest.getResourceHandlingOption()));
        }
        if (simulatePrincipalPolicyRequest.getMaxItems() != null) {
            request.addParameter("MaxItems", StringUtils.fromInteger((Integer)simulatePrincipalPolicyRequest.getMaxItems()));
        }
        if (simulatePrincipalPolicyRequest.getMarker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)simulatePrincipalPolicyRequest.getMarker()));
        }
        return request;
    }
}

