/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.TLEData;

@SdkInternalApi
public class TLEDataMarshaller {
    private static final MarshallingInfo<String> TLELINE1_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tleLine1").build();
    private static final MarshallingInfo<String> TLELINE2_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tleLine2").build();
    private static final MarshallingInfo<StructuredPojo> VALIDTIMERANGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("validTimeRange").build();
    private static final TLEDataMarshaller instance = new TLEDataMarshaller();

    public static TLEDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(TLEData tLEData, ProtocolMarshaller protocolMarshaller) {
        if (tLEData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)tLEData.getTleLine1(), TLELINE1_BINDING);
            protocolMarshaller.marshall((Object)tLEData.getTleLine2(), TLELINE2_BINDING);
            protocolMarshaller.marshall((Object)tLEData.getValidTimeRange(), VALIDTIMERANGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

