/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.groundstation.model.SatelliteListItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListSatellitesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String nextToken;
    private List<SatelliteListItem> satellites;

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListSatellitesResult withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<SatelliteListItem> getSatellites() {
        return this.satellites;
    }

    public void setSatellites(Collection<SatelliteListItem> satellites) {
        if (satellites == null) {
            this.satellites = null;
            return;
        }
        this.satellites = new ArrayList<SatelliteListItem>(satellites);
    }

    public ListSatellitesResult withSatellites(SatelliteListItem ... satellites) {
        if (this.satellites == null) {
            this.setSatellites(new ArrayList<SatelliteListItem>(satellites.length));
        }
        for (SatelliteListItem ele : satellites) {
            this.satellites.add(ele);
        }
        return this;
    }

    public ListSatellitesResult withSatellites(Collection<SatelliteListItem> satellites) {
        this.setSatellites(satellites);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getSatellites() != null) {
            sb.append("Satellites: ").append(this.getSatellites());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSatellitesResult)) {
            return false;
        }
        ListSatellitesResult other = (ListSatellitesResult)obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getSatellites() == null ^ this.getSatellites() == null) {
            return false;
        }
        return other.getSatellites() == null || other.getSatellites().equals(this.getSatellites());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getSatellites() == null ? 0 : this.getSatellites().hashCode());
        return hashCode;
    }

    public ListSatellitesResult clone() {
        try {
            return (ListSatellitesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

