/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.groundstation.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.groundstation.model.EphemerisData;

@SdkInternalApi
public class EphemerisDataMarshaller {
    private static final MarshallingInfo<StructuredPojo> OEM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("oem").build();
    private static final MarshallingInfo<StructuredPojo> TLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("tle").build();
    private static final EphemerisDataMarshaller instance = new EphemerisDataMarshaller();

    public static EphemerisDataMarshaller getInstance() {
        return instance;
    }

    public void marshall(EphemerisData ephemerisData, ProtocolMarshaller protocolMarshaller) {
        if (ephemerisData == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)ephemerisData.getOem(), OEM_BINDING);
            protocolMarshaller.marshall((Object)ephemerisData.getTle(), TLE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

