/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.S3SourceAdditionalOptions;
import com.amazonaws.services.glue.model.transform.S3CatalogSourceMarshaller;
import java.io.Serializable;

public class S3CatalogSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String database;
    private String table;
    private String partitionPredicate;
    private S3SourceAdditionalOptions additionalOptions;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public S3CatalogSource withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public String getDatabase() {
        return this.database;
    }

    public S3CatalogSource withDatabase(String database) {
        this.setDatabase(database);
        return this;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public String getTable() {
        return this.table;
    }

    public S3CatalogSource withTable(String table) {
        this.setTable(table);
        return this;
    }

    public void setPartitionPredicate(String partitionPredicate) {
        this.partitionPredicate = partitionPredicate;
    }

    public String getPartitionPredicate() {
        return this.partitionPredicate;
    }

    public S3CatalogSource withPartitionPredicate(String partitionPredicate) {
        this.setPartitionPredicate(partitionPredicate);
        return this;
    }

    public void setAdditionalOptions(S3SourceAdditionalOptions additionalOptions) {
        this.additionalOptions = additionalOptions;
    }

    public S3SourceAdditionalOptions getAdditionalOptions() {
        return this.additionalOptions;
    }

    public S3CatalogSource withAdditionalOptions(S3SourceAdditionalOptions additionalOptions) {
        this.setAdditionalOptions(additionalOptions);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDatabase() != null) {
            sb.append("Database: ").append(this.getDatabase()).append(",");
        }
        if (this.getTable() != null) {
            sb.append("Table: ").append(this.getTable()).append(",");
        }
        if (this.getPartitionPredicate() != null) {
            sb.append("PartitionPredicate: ").append(this.getPartitionPredicate()).append(",");
        }
        if (this.getAdditionalOptions() != null) {
            sb.append("AdditionalOptions: ").append(this.getAdditionalOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3CatalogSource)) {
            return false;
        }
        S3CatalogSource other = (S3CatalogSource)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDatabase() == null ^ this.getDatabase() == null) {
            return false;
        }
        if (other.getDatabase() != null && !other.getDatabase().equals(this.getDatabase())) {
            return false;
        }
        if (other.getTable() == null ^ this.getTable() == null) {
            return false;
        }
        if (other.getTable() != null && !other.getTable().equals(this.getTable())) {
            return false;
        }
        if (other.getPartitionPredicate() == null ^ this.getPartitionPredicate() == null) {
            return false;
        }
        if (other.getPartitionPredicate() != null && !other.getPartitionPredicate().equals(this.getPartitionPredicate())) {
            return false;
        }
        if (other.getAdditionalOptions() == null ^ this.getAdditionalOptions() == null) {
            return false;
        }
        return other.getAdditionalOptions() == null || other.getAdditionalOptions().equals(this.getAdditionalOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDatabase() == null ? 0 : this.getDatabase().hashCode());
        hashCode = 31 * hashCode + (this.getTable() == null ? 0 : this.getTable().hashCode());
        hashCode = 31 * hashCode + (this.getPartitionPredicate() == null ? 0 : this.getPartitionPredicate().hashCode());
        hashCode = 31 * hashCode + (this.getAdditionalOptions() == null ? 0 : this.getAdditionalOptions().hashCode());
        return hashCode;
    }

    public S3CatalogSource clone() {
        try {
            return (S3CatalogSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        S3CatalogSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

