/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.globalaccelerator.model.CustomRoutingDestinationTrafficState;
import com.amazonaws.services.globalaccelerator.model.CustomRoutingProtocol;
import com.amazonaws.services.globalaccelerator.model.SocketAddress;
import com.amazonaws.services.globalaccelerator.model.transform.PortMappingMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PortMapping
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer acceleratorPort;
    private String endpointGroupArn;
    private String endpointId;
    private SocketAddress destinationSocketAddress;
    private List<String> protocols;
    private String destinationTrafficState;

    public void setAcceleratorPort(Integer acceleratorPort) {
        this.acceleratorPort = acceleratorPort;
    }

    public Integer getAcceleratorPort() {
        return this.acceleratorPort;
    }

    public PortMapping withAcceleratorPort(Integer acceleratorPort) {
        this.setAcceleratorPort(acceleratorPort);
        return this;
    }

    public void setEndpointGroupArn(String endpointGroupArn) {
        this.endpointGroupArn = endpointGroupArn;
    }

    public String getEndpointGroupArn() {
        return this.endpointGroupArn;
    }

    public PortMapping withEndpointGroupArn(String endpointGroupArn) {
        this.setEndpointGroupArn(endpointGroupArn);
        return this;
    }

    public void setEndpointId(String endpointId) {
        this.endpointId = endpointId;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public PortMapping withEndpointId(String endpointId) {
        this.setEndpointId(endpointId);
        return this;
    }

    public void setDestinationSocketAddress(SocketAddress destinationSocketAddress) {
        this.destinationSocketAddress = destinationSocketAddress;
    }

    public SocketAddress getDestinationSocketAddress() {
        return this.destinationSocketAddress;
    }

    public PortMapping withDestinationSocketAddress(SocketAddress destinationSocketAddress) {
        this.setDestinationSocketAddress(destinationSocketAddress);
        return this;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(Collection<String> protocols) {
        if (protocols == null) {
            this.protocols = null;
            return;
        }
        this.protocols = new ArrayList<String>(protocols);
    }

    public PortMapping withProtocols(String ... protocols) {
        if (this.protocols == null) {
            this.setProtocols(new ArrayList<String>(protocols.length));
        }
        for (String ele : protocols) {
            this.protocols.add(ele);
        }
        return this;
    }

    public PortMapping withProtocols(Collection<String> protocols) {
        this.setProtocols(protocols);
        return this;
    }

    public PortMapping withProtocols(CustomRoutingProtocol ... protocols) {
        ArrayList<String> protocolsCopy = new ArrayList<String>(protocols.length);
        for (CustomRoutingProtocol value : protocols) {
            protocolsCopy.add(value.toString());
        }
        if (this.getProtocols() == null) {
            this.setProtocols(protocolsCopy);
        } else {
            this.getProtocols().addAll(protocolsCopy);
        }
        return this;
    }

    public void setDestinationTrafficState(String destinationTrafficState) {
        this.destinationTrafficState = destinationTrafficState;
    }

    public String getDestinationTrafficState() {
        return this.destinationTrafficState;
    }

    public PortMapping withDestinationTrafficState(String destinationTrafficState) {
        this.setDestinationTrafficState(destinationTrafficState);
        return this;
    }

    public PortMapping withDestinationTrafficState(CustomRoutingDestinationTrafficState destinationTrafficState) {
        this.destinationTrafficState = destinationTrafficState.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAcceleratorPort() != null) {
            sb.append("AcceleratorPort: ").append(this.getAcceleratorPort()).append(",");
        }
        if (this.getEndpointGroupArn() != null) {
            sb.append("EndpointGroupArn: ").append(this.getEndpointGroupArn()).append(",");
        }
        if (this.getEndpointId() != null) {
            sb.append("EndpointId: ").append(this.getEndpointId()).append(",");
        }
        if (this.getDestinationSocketAddress() != null) {
            sb.append("DestinationSocketAddress: ").append(this.getDestinationSocketAddress()).append(",");
        }
        if (this.getProtocols() != null) {
            sb.append("Protocols: ").append(this.getProtocols()).append(",");
        }
        if (this.getDestinationTrafficState() != null) {
            sb.append("DestinationTrafficState: ").append(this.getDestinationTrafficState());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortMapping)) {
            return false;
        }
        PortMapping other = (PortMapping)obj;
        if (other.getAcceleratorPort() == null ^ this.getAcceleratorPort() == null) {
            return false;
        }
        if (other.getAcceleratorPort() != null && !other.getAcceleratorPort().equals(this.getAcceleratorPort())) {
            return false;
        }
        if (other.getEndpointGroupArn() == null ^ this.getEndpointGroupArn() == null) {
            return false;
        }
        if (other.getEndpointGroupArn() != null && !other.getEndpointGroupArn().equals(this.getEndpointGroupArn())) {
            return false;
        }
        if (other.getEndpointId() == null ^ this.getEndpointId() == null) {
            return false;
        }
        if (other.getEndpointId() != null && !other.getEndpointId().equals(this.getEndpointId())) {
            return false;
        }
        if (other.getDestinationSocketAddress() == null ^ this.getDestinationSocketAddress() == null) {
            return false;
        }
        if (other.getDestinationSocketAddress() != null && !other.getDestinationSocketAddress().equals(this.getDestinationSocketAddress())) {
            return false;
        }
        if (other.getProtocols() == null ^ this.getProtocols() == null) {
            return false;
        }
        if (other.getProtocols() != null && !other.getProtocols().equals(this.getProtocols())) {
            return false;
        }
        if (other.getDestinationTrafficState() == null ^ this.getDestinationTrafficState() == null) {
            return false;
        }
        return other.getDestinationTrafficState() == null || other.getDestinationTrafficState().equals(this.getDestinationTrafficState());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAcceleratorPort() == null ? 0 : this.getAcceleratorPort().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointGroupArn() == null ? 0 : this.getEndpointGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getEndpointId() == null ? 0 : this.getEndpointId().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationSocketAddress() == null ? 0 : this.getDestinationSocketAddress().hashCode());
        hashCode = 31 * hashCode + (this.getProtocols() == null ? 0 : this.getProtocols().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationTrafficState() == null ? 0 : this.getDestinationTrafficState().hashCode());
        return hashCode;
    }

    public PortMapping clone() {
        try {
            return (PortMapping)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PortMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

