/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.gamelift.model.LocationFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListLocationsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<String> filters;
    private Integer limit;
    private String nextToken;

    public List<String> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<String> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new ArrayList<String>(filters);
    }

    public ListLocationsRequest withFilters(String ... filters) {
        if (this.filters == null) {
            this.setFilters(new ArrayList<String>(filters.length));
        }
        for (String ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public ListLocationsRequest withFilters(Collection<String> filters) {
        this.setFilters(filters);
        return this;
    }

    public ListLocationsRequest withFilters(LocationFilter ... filters) {
        ArrayList<String> filtersCopy = new ArrayList<String>(filters.length);
        for (LocationFilter value : filters) {
            filtersCopy.add(value.toString());
        }
        if (this.getFilters() == null) {
            this.setFilters(filtersCopy);
        } else {
            this.getFilters().addAll(filtersCopy);
        }
        return this;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public ListLocationsRequest withLimit(Integer limit) {
        this.setLimit(limit);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListLocationsRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getLimit() != null) {
            sb.append("Limit: ").append(this.getLimit()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLocationsRequest)) {
            return false;
        }
        ListLocationsRequest other = (ListLocationsRequest)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getLimit() == null ^ this.getLimit() == null) {
            return false;
        }
        if (other.getLimit() != null && !other.getLimit().equals(this.getLimit())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getLimit() == null ? 0 : this.getLimit().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListLocationsRequest clone() {
        return (ListLocationsRequest)super.clone();
    }
}

