/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.frauddetector.model.EvaluatedRule;
import java.util.List;

@SdkInternalApi
public class EvaluatedRuleMarshaller {
    private static final MarshallingInfo<String> RULEID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ruleId").build();
    private static final MarshallingInfo<String> RULEVERSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ruleVersion").build();
    private static final MarshallingInfo<String> EXPRESSION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expression").build();
    private static final MarshallingInfo<String> EXPRESSIONWITHVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("expressionWithValues").build();
    private static final MarshallingInfo<List> OUTCOMES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("outcomes").build();
    private static final MarshallingInfo<Boolean> EVALUATED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("evaluated").build();
    private static final MarshallingInfo<Boolean> MATCHED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("matched").build();
    private static final EvaluatedRuleMarshaller instance = new EvaluatedRuleMarshaller();

    public static EvaluatedRuleMarshaller getInstance() {
        return instance;
    }

    public void marshall(EvaluatedRule evaluatedRule, ProtocolMarshaller protocolMarshaller) {
        if (evaluatedRule == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)evaluatedRule.getRuleId(), RULEID_BINDING);
            protocolMarshaller.marshall((Object)evaluatedRule.getRuleVersion(), RULEVERSION_BINDING);
            protocolMarshaller.marshall((Object)evaluatedRule.getExpression(), EXPRESSION_BINDING);
            protocolMarshaller.marshall((Object)evaluatedRule.getExpressionWithValues(), EXPRESSIONWITHVALUES_BINDING);
            protocolMarshaller.marshall(evaluatedRule.getOutcomes(), OUTCOMES_BINDING);
            protocolMarshaller.marshall((Object)evaluatedRule.getEvaluated(), EVALUATED_BINDING);
            protocolMarshaller.marshall((Object)evaluatedRule.getMatched(), MATCHED_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

