/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.TFIMetricDataPoint;
import com.amazonaws.services.frauddetector.model.TFIModelPerformance;
import com.amazonaws.services.frauddetector.model.transform.TFITrainingMetricsValueMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TFITrainingMetricsValue
implements Serializable,
Cloneable,
StructuredPojo {
    private List<TFIMetricDataPoint> metricDataPoints;
    private TFIModelPerformance modelPerformance;

    public List<TFIMetricDataPoint> getMetricDataPoints() {
        return this.metricDataPoints;
    }

    public void setMetricDataPoints(Collection<TFIMetricDataPoint> metricDataPoints) {
        if (metricDataPoints == null) {
            this.metricDataPoints = null;
            return;
        }
        this.metricDataPoints = new ArrayList<TFIMetricDataPoint>(metricDataPoints);
    }

    public TFITrainingMetricsValue withMetricDataPoints(TFIMetricDataPoint ... metricDataPoints) {
        if (this.metricDataPoints == null) {
            this.setMetricDataPoints(new ArrayList<TFIMetricDataPoint>(metricDataPoints.length));
        }
        for (TFIMetricDataPoint ele : metricDataPoints) {
            this.metricDataPoints.add(ele);
        }
        return this;
    }

    public TFITrainingMetricsValue withMetricDataPoints(Collection<TFIMetricDataPoint> metricDataPoints) {
        this.setMetricDataPoints(metricDataPoints);
        return this;
    }

    public void setModelPerformance(TFIModelPerformance modelPerformance) {
        this.modelPerformance = modelPerformance;
    }

    public TFIModelPerformance getModelPerformance() {
        return this.modelPerformance;
    }

    public TFITrainingMetricsValue withModelPerformance(TFIModelPerformance modelPerformance) {
        this.setModelPerformance(modelPerformance);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMetricDataPoints() != null) {
            sb.append("MetricDataPoints: ").append(this.getMetricDataPoints()).append(",");
        }
        if (this.getModelPerformance() != null) {
            sb.append("ModelPerformance: ").append(this.getModelPerformance());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TFITrainingMetricsValue)) {
            return false;
        }
        TFITrainingMetricsValue other = (TFITrainingMetricsValue)obj;
        if (other.getMetricDataPoints() == null ^ this.getMetricDataPoints() == null) {
            return false;
        }
        if (other.getMetricDataPoints() != null && !other.getMetricDataPoints().equals(this.getMetricDataPoints())) {
            return false;
        }
        if (other.getModelPerformance() == null ^ this.getModelPerformance() == null) {
            return false;
        }
        return other.getModelPerformance() == null || other.getModelPerformance().equals(this.getModelPerformance());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMetricDataPoints() == null ? 0 : this.getMetricDataPoints().hashCode());
        hashCode = 31 * hashCode + (this.getModelPerformance() == null ? 0 : this.getModelPerformance().hashCode());
        return hashCode;
    }

    public TFITrainingMetricsValue clone() {
        try {
            return (TFITrainingMetricsValue)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TFITrainingMetricsValueMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

