/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.emrcontainers.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.emrcontainers.model.ContainerProviderType;
import com.amazonaws.services.emrcontainers.model.VirtualClusterState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class ListVirtualClustersRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String containerProviderId;
    private String containerProviderType;
    private Date createdAfter;
    private Date createdBefore;
    private List<String> states;
    private Integer maxResults;
    private String nextToken;

    public void setContainerProviderId(String containerProviderId) {
        this.containerProviderId = containerProviderId;
    }

    public String getContainerProviderId() {
        return this.containerProviderId;
    }

    public ListVirtualClustersRequest withContainerProviderId(String containerProviderId) {
        this.setContainerProviderId(containerProviderId);
        return this;
    }

    public void setContainerProviderType(String containerProviderType) {
        this.containerProviderType = containerProviderType;
    }

    public String getContainerProviderType() {
        return this.containerProviderType;
    }

    public ListVirtualClustersRequest withContainerProviderType(String containerProviderType) {
        this.setContainerProviderType(containerProviderType);
        return this;
    }

    public ListVirtualClustersRequest withContainerProviderType(ContainerProviderType containerProviderType) {
        this.containerProviderType = containerProviderType.toString();
        return this;
    }

    public void setCreatedAfter(Date createdAfter) {
        this.createdAfter = createdAfter;
    }

    public Date getCreatedAfter() {
        return this.createdAfter;
    }

    public ListVirtualClustersRequest withCreatedAfter(Date createdAfter) {
        this.setCreatedAfter(createdAfter);
        return this;
    }

    public void setCreatedBefore(Date createdBefore) {
        this.createdBefore = createdBefore;
    }

    public Date getCreatedBefore() {
        return this.createdBefore;
    }

    public ListVirtualClustersRequest withCreatedBefore(Date createdBefore) {
        this.setCreatedBefore(createdBefore);
        return this;
    }

    public List<String> getStates() {
        return this.states;
    }

    public void setStates(Collection<String> states) {
        if (states == null) {
            this.states = null;
            return;
        }
        this.states = new ArrayList<String>(states);
    }

    public ListVirtualClustersRequest withStates(String ... states) {
        if (this.states == null) {
            this.setStates(new ArrayList<String>(states.length));
        }
        for (String ele : states) {
            this.states.add(ele);
        }
        return this;
    }

    public ListVirtualClustersRequest withStates(Collection<String> states) {
        this.setStates(states);
        return this;
    }

    public ListVirtualClustersRequest withStates(VirtualClusterState ... states) {
        ArrayList<String> statesCopy = new ArrayList<String>(states.length);
        for (VirtualClusterState value : states) {
            statesCopy.add(value.toString());
        }
        if (this.getStates() == null) {
            this.setStates(statesCopy);
        } else {
            this.getStates().addAll(statesCopy);
        }
        return this;
    }

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListVirtualClustersRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListVirtualClustersRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerProviderId() != null) {
            sb.append("ContainerProviderId: ").append(this.getContainerProviderId()).append(",");
        }
        if (this.getContainerProviderType() != null) {
            sb.append("ContainerProviderType: ").append(this.getContainerProviderType()).append(",");
        }
        if (this.getCreatedAfter() != null) {
            sb.append("CreatedAfter: ").append(this.getCreatedAfter()).append(",");
        }
        if (this.getCreatedBefore() != null) {
            sb.append("CreatedBefore: ").append(this.getCreatedBefore()).append(",");
        }
        if (this.getStates() != null) {
            sb.append("States: ").append(this.getStates()).append(",");
        }
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualClustersRequest)) {
            return false;
        }
        ListVirtualClustersRequest other = (ListVirtualClustersRequest)obj;
        if (other.getContainerProviderId() == null ^ this.getContainerProviderId() == null) {
            return false;
        }
        if (other.getContainerProviderId() != null && !other.getContainerProviderId().equals(this.getContainerProviderId())) {
            return false;
        }
        if (other.getContainerProviderType() == null ^ this.getContainerProviderType() == null) {
            return false;
        }
        if (other.getContainerProviderType() != null && !other.getContainerProviderType().equals(this.getContainerProviderType())) {
            return false;
        }
        if (other.getCreatedAfter() == null ^ this.getCreatedAfter() == null) {
            return false;
        }
        if (other.getCreatedAfter() != null && !other.getCreatedAfter().equals(this.getCreatedAfter())) {
            return false;
        }
        if (other.getCreatedBefore() == null ^ this.getCreatedBefore() == null) {
            return false;
        }
        if (other.getCreatedBefore() != null && !other.getCreatedBefore().equals(this.getCreatedBefore())) {
            return false;
        }
        if (other.getStates() == null ^ this.getStates() == null) {
            return false;
        }
        if (other.getStates() != null && !other.getStates().equals(this.getStates())) {
            return false;
        }
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        return other.getNextToken() == null || other.getNextToken().equals(this.getNextToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerProviderId() == null ? 0 : this.getContainerProviderId().hashCode());
        hashCode = 31 * hashCode + (this.getContainerProviderType() == null ? 0 : this.getContainerProviderType().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAfter() == null ? 0 : this.getCreatedAfter().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedBefore() == null ? 0 : this.getCreatedBefore().hashCode());
        hashCode = 31 * hashCode + (this.getStates() == null ? 0 : this.getStates().hashCode());
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        return hashCode;
    }

    public ListVirtualClustersRequest clone() {
        return (ListVirtualClustersRequest)super.clone();
    }
}

