/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticmapreduce.model.InstanceGroupDetail;
import com.amazonaws.services.elasticmapreduce.model.PlacementType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JobFlowInstancesDetail
implements Serializable,
Cloneable {
    private String masterInstanceType;
    private String masterPublicDnsName;
    private String masterInstanceId;
    private String slaveInstanceType;
    private Integer instanceCount;
    private ListWithAutoConstructFlag<InstanceGroupDetail> instanceGroups;
    private Integer normalizedInstanceHours;
    private String ec2KeyName;
    private String ec2SubnetId;
    private PlacementType placement;
    private Boolean keepJobFlowAliveWhenNoSteps;
    private Boolean terminationProtected;
    private String hadoopVersion;

    public JobFlowInstancesDetail() {
    }

    public JobFlowInstancesDetail(String masterInstanceType, String slaveInstanceType, Integer instanceCount) {
        this.setMasterInstanceType(masterInstanceType);
        this.setSlaveInstanceType(slaveInstanceType);
        this.setInstanceCount(instanceCount);
    }

    public String getMasterInstanceType() {
        return this.masterInstanceType;
    }

    public void setMasterInstanceType(String masterInstanceType) {
        this.masterInstanceType = masterInstanceType;
    }

    public JobFlowInstancesDetail withMasterInstanceType(String masterInstanceType) {
        this.masterInstanceType = masterInstanceType;
        return this;
    }

    public String getMasterPublicDnsName() {
        return this.masterPublicDnsName;
    }

    public void setMasterPublicDnsName(String masterPublicDnsName) {
        this.masterPublicDnsName = masterPublicDnsName;
    }

    public JobFlowInstancesDetail withMasterPublicDnsName(String masterPublicDnsName) {
        this.masterPublicDnsName = masterPublicDnsName;
        return this;
    }

    public String getMasterInstanceId() {
        return this.masterInstanceId;
    }

    public void setMasterInstanceId(String masterInstanceId) {
        this.masterInstanceId = masterInstanceId;
    }

    public JobFlowInstancesDetail withMasterInstanceId(String masterInstanceId) {
        this.masterInstanceId = masterInstanceId;
        return this;
    }

    public String getSlaveInstanceType() {
        return this.slaveInstanceType;
    }

    public void setSlaveInstanceType(String slaveInstanceType) {
        this.slaveInstanceType = slaveInstanceType;
    }

    public JobFlowInstancesDetail withSlaveInstanceType(String slaveInstanceType) {
        this.slaveInstanceType = slaveInstanceType;
        return this;
    }

    public Integer getInstanceCount() {
        return this.instanceCount;
    }

    public void setInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
    }

    public JobFlowInstancesDetail withInstanceCount(Integer instanceCount) {
        this.instanceCount = instanceCount;
        return this;
    }

    public List<InstanceGroupDetail> getInstanceGroups() {
        if (this.instanceGroups == null) {
            this.instanceGroups = new ListWithAutoConstructFlag();
            this.instanceGroups.setAutoConstruct(true);
        }
        return this.instanceGroups;
    }

    public void setInstanceGroups(Collection<InstanceGroupDetail> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
            return;
        }
        ListWithAutoConstructFlag instanceGroupsCopy = new ListWithAutoConstructFlag(instanceGroups.size());
        instanceGroupsCopy.addAll(instanceGroups);
        this.instanceGroups = instanceGroupsCopy;
    }

    public JobFlowInstancesDetail withInstanceGroups(InstanceGroupDetail ... instanceGroups) {
        if (this.getInstanceGroups() == null) {
            this.setInstanceGroups(new ArrayList<InstanceGroupDetail>(instanceGroups.length));
        }
        for (InstanceGroupDetail value : instanceGroups) {
            this.getInstanceGroups().add(value);
        }
        return this;
    }

    public JobFlowInstancesDetail withInstanceGroups(Collection<InstanceGroupDetail> instanceGroups) {
        if (instanceGroups == null) {
            this.instanceGroups = null;
        } else {
            ListWithAutoConstructFlag instanceGroupsCopy = new ListWithAutoConstructFlag(instanceGroups.size());
            instanceGroupsCopy.addAll(instanceGroups);
            this.instanceGroups = instanceGroupsCopy;
        }
        return this;
    }

    public Integer getNormalizedInstanceHours() {
        return this.normalizedInstanceHours;
    }

    public void setNormalizedInstanceHours(Integer normalizedInstanceHours) {
        this.normalizedInstanceHours = normalizedInstanceHours;
    }

    public JobFlowInstancesDetail withNormalizedInstanceHours(Integer normalizedInstanceHours) {
        this.normalizedInstanceHours = normalizedInstanceHours;
        return this;
    }

    public String getEc2KeyName() {
        return this.ec2KeyName;
    }

    public void setEc2KeyName(String ec2KeyName) {
        this.ec2KeyName = ec2KeyName;
    }

    public JobFlowInstancesDetail withEc2KeyName(String ec2KeyName) {
        this.ec2KeyName = ec2KeyName;
        return this;
    }

    public String getEc2SubnetId() {
        return this.ec2SubnetId;
    }

    public void setEc2SubnetId(String ec2SubnetId) {
        this.ec2SubnetId = ec2SubnetId;
    }

    public JobFlowInstancesDetail withEc2SubnetId(String ec2SubnetId) {
        this.ec2SubnetId = ec2SubnetId;
        return this;
    }

    public PlacementType getPlacement() {
        return this.placement;
    }

    public void setPlacement(PlacementType placement) {
        this.placement = placement;
    }

    public JobFlowInstancesDetail withPlacement(PlacementType placement) {
        this.placement = placement;
        return this;
    }

    public Boolean isKeepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public void setKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
        this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
    }

    public JobFlowInstancesDetail withKeepJobFlowAliveWhenNoSteps(Boolean keepJobFlowAliveWhenNoSteps) {
        this.keepJobFlowAliveWhenNoSteps = keepJobFlowAliveWhenNoSteps;
        return this;
    }

    public Boolean getKeepJobFlowAliveWhenNoSteps() {
        return this.keepJobFlowAliveWhenNoSteps;
    }

    public Boolean isTerminationProtected() {
        return this.terminationProtected;
    }

    public void setTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
    }

    public JobFlowInstancesDetail withTerminationProtected(Boolean terminationProtected) {
        this.terminationProtected = terminationProtected;
        return this;
    }

    public Boolean getTerminationProtected() {
        return this.terminationProtected;
    }

    public String getHadoopVersion() {
        return this.hadoopVersion;
    }

    public void setHadoopVersion(String hadoopVersion) {
        this.hadoopVersion = hadoopVersion;
    }

    public JobFlowInstancesDetail withHadoopVersion(String hadoopVersion) {
        this.hadoopVersion = hadoopVersion;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMasterInstanceType() != null) {
            sb.append("MasterInstanceType: " + this.getMasterInstanceType() + ",");
        }
        if (this.getMasterPublicDnsName() != null) {
            sb.append("MasterPublicDnsName: " + this.getMasterPublicDnsName() + ",");
        }
        if (this.getMasterInstanceId() != null) {
            sb.append("MasterInstanceId: " + this.getMasterInstanceId() + ",");
        }
        if (this.getSlaveInstanceType() != null) {
            sb.append("SlaveInstanceType: " + this.getSlaveInstanceType() + ",");
        }
        if (this.getInstanceCount() != null) {
            sb.append("InstanceCount: " + this.getInstanceCount() + ",");
        }
        if (this.getInstanceGroups() != null) {
            sb.append("InstanceGroups: " + this.getInstanceGroups() + ",");
        }
        if (this.getNormalizedInstanceHours() != null) {
            sb.append("NormalizedInstanceHours: " + this.getNormalizedInstanceHours() + ",");
        }
        if (this.getEc2KeyName() != null) {
            sb.append("Ec2KeyName: " + this.getEc2KeyName() + ",");
        }
        if (this.getEc2SubnetId() != null) {
            sb.append("Ec2SubnetId: " + this.getEc2SubnetId() + ",");
        }
        if (this.getPlacement() != null) {
            sb.append("Placement: " + this.getPlacement() + ",");
        }
        if (this.isKeepJobFlowAliveWhenNoSteps() != null) {
            sb.append("KeepJobFlowAliveWhenNoSteps: " + this.isKeepJobFlowAliveWhenNoSteps() + ",");
        }
        if (this.isTerminationProtected() != null) {
            sb.append("TerminationProtected: " + this.isTerminationProtected() + ",");
        }
        if (this.getHadoopVersion() != null) {
            sb.append("HadoopVersion: " + this.getHadoopVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMasterInstanceType() == null ? 0 : this.getMasterInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getMasterPublicDnsName() == null ? 0 : this.getMasterPublicDnsName().hashCode());
        hashCode = 31 * hashCode + (this.getMasterInstanceId() == null ? 0 : this.getMasterInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getSlaveInstanceType() == null ? 0 : this.getSlaveInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceCount() == null ? 0 : this.getInstanceCount().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceGroups() == null ? 0 : this.getInstanceGroups().hashCode());
        hashCode = 31 * hashCode + (this.getNormalizedInstanceHours() == null ? 0 : this.getNormalizedInstanceHours().hashCode());
        hashCode = 31 * hashCode + (this.getEc2KeyName() == null ? 0 : this.getEc2KeyName().hashCode());
        hashCode = 31 * hashCode + (this.getEc2SubnetId() == null ? 0 : this.getEc2SubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.isKeepJobFlowAliveWhenNoSteps() == null ? 0 : this.isKeepJobFlowAliveWhenNoSteps().hashCode());
        hashCode = 31 * hashCode + (this.isTerminationProtected() == null ? 0 : this.isTerminationProtected().hashCode());
        hashCode = 31 * hashCode + (this.getHadoopVersion() == null ? 0 : this.getHadoopVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobFlowInstancesDetail)) {
            return false;
        }
        JobFlowInstancesDetail other = (JobFlowInstancesDetail)obj;
        if (other.getMasterInstanceType() == null ^ this.getMasterInstanceType() == null) {
            return false;
        }
        if (other.getMasterInstanceType() != null && !other.getMasterInstanceType().equals(this.getMasterInstanceType())) {
            return false;
        }
        if (other.getMasterPublicDnsName() == null ^ this.getMasterPublicDnsName() == null) {
            return false;
        }
        if (other.getMasterPublicDnsName() != null && !other.getMasterPublicDnsName().equals(this.getMasterPublicDnsName())) {
            return false;
        }
        if (other.getMasterInstanceId() == null ^ this.getMasterInstanceId() == null) {
            return false;
        }
        if (other.getMasterInstanceId() != null && !other.getMasterInstanceId().equals(this.getMasterInstanceId())) {
            return false;
        }
        if (other.getSlaveInstanceType() == null ^ this.getSlaveInstanceType() == null) {
            return false;
        }
        if (other.getSlaveInstanceType() != null && !other.getSlaveInstanceType().equals(this.getSlaveInstanceType())) {
            return false;
        }
        if (other.getInstanceCount() == null ^ this.getInstanceCount() == null) {
            return false;
        }
        if (other.getInstanceCount() != null && !other.getInstanceCount().equals(this.getInstanceCount())) {
            return false;
        }
        if (other.getInstanceGroups() == null ^ this.getInstanceGroups() == null) {
            return false;
        }
        if (other.getInstanceGroups() != null && !other.getInstanceGroups().equals(this.getInstanceGroups())) {
            return false;
        }
        if (other.getNormalizedInstanceHours() == null ^ this.getNormalizedInstanceHours() == null) {
            return false;
        }
        if (other.getNormalizedInstanceHours() != null && !other.getNormalizedInstanceHours().equals(this.getNormalizedInstanceHours())) {
            return false;
        }
        if (other.getEc2KeyName() == null ^ this.getEc2KeyName() == null) {
            return false;
        }
        if (other.getEc2KeyName() != null && !other.getEc2KeyName().equals(this.getEc2KeyName())) {
            return false;
        }
        if (other.getEc2SubnetId() == null ^ this.getEc2SubnetId() == null) {
            return false;
        }
        if (other.getEc2SubnetId() != null && !other.getEc2SubnetId().equals(this.getEc2SubnetId())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.isKeepJobFlowAliveWhenNoSteps() == null ^ this.isKeepJobFlowAliveWhenNoSteps() == null) {
            return false;
        }
        if (other.isKeepJobFlowAliveWhenNoSteps() != null && !other.isKeepJobFlowAliveWhenNoSteps().equals(this.isKeepJobFlowAliveWhenNoSteps())) {
            return false;
        }
        if (other.isTerminationProtected() == null ^ this.isTerminationProtected() == null) {
            return false;
        }
        if (other.isTerminationProtected() != null && !other.isTerminationProtected().equals(this.isTerminationProtected())) {
            return false;
        }
        if (other.getHadoopVersion() == null ^ this.getHadoopVersion() == null) {
            return false;
        }
        return other.getHadoopVersion() == null || other.getHadoopVersion().equals(this.getHadoopVersion());
    }

    public JobFlowInstancesDetail clone() {
        try {
            return (JobFlowInstancesDetail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

