/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.elasticmapreduce.model.InstanceTimeline;
import java.util.Date;

@SdkInternalApi
public class InstanceTimelineMarshaller {
    private static final MarshallingInfo<Date> CREATIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> READYDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReadyDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndDateTime").timestampFormat("unixTimestamp").build();
    private static final InstanceTimelineMarshaller instance = new InstanceTimelineMarshaller();

    public static InstanceTimelineMarshaller getInstance() {
        return instance;
    }

    public void marshall(InstanceTimeline instanceTimeline, ProtocolMarshaller protocolMarshaller) {
        if (instanceTimeline == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)instanceTimeline.getCreationDateTime(), CREATIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)instanceTimeline.getReadyDateTime(), READYDATETIME_BINDING);
            protocolMarshaller.marshall((Object)instanceTimeline.getEndDateTime(), ENDDATETIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

