/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalk;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.waiters.DescribeEnvironmentsFunction;
import com.amazonaws.services.elasticbeanstalk.waiters.EnvironmentExists;
import com.amazonaws.services.elasticbeanstalk.waiters.EnvironmentTerminated;
import com.amazonaws.services.elasticbeanstalk.waiters.EnvironmentUpdated;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AWSElasticBeanstalkWaiters {
    private final AWSElasticBeanstalk client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AWSElasticBeanstalkWaiters");

    @SdkInternalApi
    public AWSElasticBeanstalkWaiters(AWSElasticBeanstalk client) {
        this.client = client;
    }

    public Waiter<DescribeEnvironmentsRequest> environmentTerminated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeEnvironmentsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new EnvironmentTerminated.IsTerminatedMatcher(), new EnvironmentTerminated.IsTerminatingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeEnvironmentsRequest> environmentUpdated() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeEnvironmentsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new EnvironmentUpdated.IsReadyMatcher(), new EnvironmentUpdated.IsUpdatingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeEnvironmentsRequest> environmentExists() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeEnvironmentsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new EnvironmentExists.IsReadyMatcher(), new EnvironmentExists.IsLaunchingMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(20), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(20))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

