/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.eks.model.InsightsFilter;
import java.util.List;

@SdkInternalApi
public class InsightsFilterMarshaller {
    private static final MarshallingInfo<List> CATEGORIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("categories").build();
    private static final MarshallingInfo<List> KUBERNETESVERSIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("kubernetesVersions").build();
    private static final MarshallingInfo<List> STATUSES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statuses").build();
    private static final InsightsFilterMarshaller instance = new InsightsFilterMarshaller();

    public static InsightsFilterMarshaller getInstance() {
        return instance;
    }

    public void marshall(InsightsFilter insightsFilter, ProtocolMarshaller protocolMarshaller) {
        if (insightsFilter == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(insightsFilter.getCategories(), CATEGORIES_BINDING);
            protocolMarshaller.marshall(insightsFilter.getKubernetesVersions(), KUBERNETESVERSIONS_BINDING);
            protocolMarshaller.marshall(insightsFilter.getStatuses(), STATUSES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

