/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListClustersRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private Integer maxResults;
    private String nextToken;
    private List<String> include;

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    public Integer getMaxResults() {
        return this.maxResults;
    }

    public ListClustersRequest withMaxResults(Integer maxResults) {
        this.setMaxResults(maxResults);
        return this;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public String getNextToken() {
        return this.nextToken;
    }

    public ListClustersRequest withNextToken(String nextToken) {
        this.setNextToken(nextToken);
        return this;
    }

    public List<String> getInclude() {
        return this.include;
    }

    public void setInclude(Collection<String> include) {
        if (include == null) {
            this.include = null;
            return;
        }
        this.include = new ArrayList<String>(include);
    }

    public ListClustersRequest withInclude(String ... include) {
        if (this.include == null) {
            this.setInclude(new ArrayList<String>(include.length));
        }
        for (String ele : include) {
            this.include.add(ele);
        }
        return this;
    }

    public ListClustersRequest withInclude(Collection<String> include) {
        this.setInclude(include);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMaxResults() != null) {
            sb.append("MaxResults: ").append(this.getMaxResults()).append(",");
        }
        if (this.getNextToken() != null) {
            sb.append("NextToken: ").append(this.getNextToken()).append(",");
        }
        if (this.getInclude() != null) {
            sb.append("Include: ").append(this.getInclude());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListClustersRequest)) {
            return false;
        }
        ListClustersRequest other = (ListClustersRequest)obj;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null) {
            return false;
        }
        if (other.getMaxResults() != null && !other.getMaxResults().equals(this.getMaxResults())) {
            return false;
        }
        if (other.getNextToken() == null ^ this.getNextToken() == null) {
            return false;
        }
        if (other.getNextToken() != null && !other.getNextToken().equals(this.getNextToken())) {
            return false;
        }
        if (other.getInclude() == null ^ this.getInclude() == null) {
            return false;
        }
        return other.getInclude() == null || other.getInclude().equals(this.getInclude());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMaxResults() == null ? 0 : this.getMaxResults().hashCode());
        hashCode = 31 * hashCode + (this.getNextToken() == null ? 0 : this.getNextToken().hashCode());
        hashCode = 31 * hashCode + (this.getInclude() == null ? 0 : this.getInclude().hashCode());
        return hashCode;
    }

    public ListClustersRequest clone() {
        return (ListClustersRequest)super.clone();
    }
}

