/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.AccessScopeType;
import com.amazonaws.services.eks.model.transform.AccessScopeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AccessScope
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private List<String> namespaces;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public AccessScope withType(String type) {
        this.setType(type);
        return this;
    }

    public AccessScope withType(AccessScopeType type) {
        this.type = type.toString();
        return this;
    }

    public List<String> getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Collection<String> namespaces) {
        if (namespaces == null) {
            this.namespaces = null;
            return;
        }
        this.namespaces = new ArrayList<String>(namespaces);
    }

    public AccessScope withNamespaces(String ... namespaces) {
        if (this.namespaces == null) {
            this.setNamespaces(new ArrayList<String>(namespaces.length));
        }
        for (String ele : namespaces) {
            this.namespaces.add(ele);
        }
        return this;
    }

    public AccessScope withNamespaces(Collection<String> namespaces) {
        this.setNamespaces(namespaces);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getNamespaces() != null) {
            sb.append("Namespaces: ").append(this.getNamespaces());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessScope)) {
            return false;
        }
        AccessScope other = (AccessScope)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getNamespaces() == null ^ this.getNamespaces() == null) {
            return false;
        }
        return other.getNamespaces() == null || other.getNamespaces().equals(this.getNamespaces());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getNamespaces() == null ? 0 : this.getNamespaces().hashCode());
        return hashCode;
    }

    public AccessScope clone() {
        try {
            return (AccessScope)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccessScopeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

