/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eks.model.AddonHealth;
import com.amazonaws.services.eks.model.AddonStatus;
import com.amazonaws.services.eks.model.MarketplaceInformation;
import com.amazonaws.services.eks.model.transform.AddonMarshaller;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Addon
implements Serializable,
Cloneable,
StructuredPojo {
    private String addonName;
    private String clusterName;
    private String status;
    private String addonVersion;
    private AddonHealth health;
    private String addonArn;
    private Date createdAt;
    private Date modifiedAt;
    private String serviceAccountRoleArn;
    private Map<String, String> tags;
    private String publisher;
    private String owner;
    private MarketplaceInformation marketplaceInformation;

    public void setAddonName(String addonName) {
        this.addonName = addonName;
    }

    public String getAddonName() {
        return this.addonName;
    }

    public Addon withAddonName(String addonName) {
        this.setAddonName(addonName);
        return this;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Addon withClusterName(String clusterName) {
        this.setClusterName(clusterName);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Addon withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public Addon withStatus(AddonStatus status) {
        this.status = status.toString();
        return this;
    }

    public void setAddonVersion(String addonVersion) {
        this.addonVersion = addonVersion;
    }

    public String getAddonVersion() {
        return this.addonVersion;
    }

    public Addon withAddonVersion(String addonVersion) {
        this.setAddonVersion(addonVersion);
        return this;
    }

    public void setHealth(AddonHealth health) {
        this.health = health;
    }

    public AddonHealth getHealth() {
        return this.health;
    }

    public Addon withHealth(AddonHealth health) {
        this.setHealth(health);
        return this;
    }

    public void setAddonArn(String addonArn) {
        this.addonArn = addonArn;
    }

    public String getAddonArn() {
        return this.addonArn;
    }

    public Addon withAddonArn(String addonArn) {
        this.setAddonArn(addonArn);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Addon withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setModifiedAt(Date modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    public Date getModifiedAt() {
        return this.modifiedAt;
    }

    public Addon withModifiedAt(Date modifiedAt) {
        this.setModifiedAt(modifiedAt);
        return this;
    }

    public void setServiceAccountRoleArn(String serviceAccountRoleArn) {
        this.serviceAccountRoleArn = serviceAccountRoleArn;
    }

    public String getServiceAccountRoleArn() {
        return this.serviceAccountRoleArn;
    }

    public Addon withServiceAccountRoleArn(String serviceAccountRoleArn) {
        this.setServiceAccountRoleArn(serviceAccountRoleArn);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public Addon withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public Addon addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public Addon clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setPublisher(String publisher) {
        this.publisher = publisher;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public Addon withPublisher(String publisher) {
        this.setPublisher(publisher);
        return this;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public Addon withOwner(String owner) {
        this.setOwner(owner);
        return this;
    }

    public void setMarketplaceInformation(MarketplaceInformation marketplaceInformation) {
        this.marketplaceInformation = marketplaceInformation;
    }

    public MarketplaceInformation getMarketplaceInformation() {
        return this.marketplaceInformation;
    }

    public Addon withMarketplaceInformation(MarketplaceInformation marketplaceInformation) {
        this.setMarketplaceInformation(marketplaceInformation);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAddonName() != null) {
            sb.append("AddonName: ").append(this.getAddonName()).append(",");
        }
        if (this.getClusterName() != null) {
            sb.append("ClusterName: ").append(this.getClusterName()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getAddonVersion() != null) {
            sb.append("AddonVersion: ").append(this.getAddonVersion()).append(",");
        }
        if (this.getHealth() != null) {
            sb.append("Health: ").append(this.getHealth()).append(",");
        }
        if (this.getAddonArn() != null) {
            sb.append("AddonArn: ").append(this.getAddonArn()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getModifiedAt() != null) {
            sb.append("ModifiedAt: ").append(this.getModifiedAt()).append(",");
        }
        if (this.getServiceAccountRoleArn() != null) {
            sb.append("ServiceAccountRoleArn: ").append(this.getServiceAccountRoleArn()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getPublisher() != null) {
            sb.append("Publisher: ").append(this.getPublisher()).append(",");
        }
        if (this.getOwner() != null) {
            sb.append("Owner: ").append(this.getOwner()).append(",");
        }
        if (this.getMarketplaceInformation() != null) {
            sb.append("MarketplaceInformation: ").append(this.getMarketplaceInformation());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Addon)) {
            return false;
        }
        Addon other = (Addon)obj;
        if (other.getAddonName() == null ^ this.getAddonName() == null) {
            return false;
        }
        if (other.getAddonName() != null && !other.getAddonName().equals(this.getAddonName())) {
            return false;
        }
        if (other.getClusterName() == null ^ this.getClusterName() == null) {
            return false;
        }
        if (other.getClusterName() != null && !other.getClusterName().equals(this.getClusterName())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getAddonVersion() == null ^ this.getAddonVersion() == null) {
            return false;
        }
        if (other.getAddonVersion() != null && !other.getAddonVersion().equals(this.getAddonVersion())) {
            return false;
        }
        if (other.getHealth() == null ^ this.getHealth() == null) {
            return false;
        }
        if (other.getHealth() != null && !other.getHealth().equals(this.getHealth())) {
            return false;
        }
        if (other.getAddonArn() == null ^ this.getAddonArn() == null) {
            return false;
        }
        if (other.getAddonArn() != null && !other.getAddonArn().equals(this.getAddonArn())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getModifiedAt() == null ^ this.getModifiedAt() == null) {
            return false;
        }
        if (other.getModifiedAt() != null && !other.getModifiedAt().equals(this.getModifiedAt())) {
            return false;
        }
        if (other.getServiceAccountRoleArn() == null ^ this.getServiceAccountRoleArn() == null) {
            return false;
        }
        if (other.getServiceAccountRoleArn() != null && !other.getServiceAccountRoleArn().equals(this.getServiceAccountRoleArn())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getPublisher() == null ^ this.getPublisher() == null) {
            return false;
        }
        if (other.getPublisher() != null && !other.getPublisher().equals(this.getPublisher())) {
            return false;
        }
        if (other.getOwner() == null ^ this.getOwner() == null) {
            return false;
        }
        if (other.getOwner() != null && !other.getOwner().equals(this.getOwner())) {
            return false;
        }
        if (other.getMarketplaceInformation() == null ^ this.getMarketplaceInformation() == null) {
            return false;
        }
        return other.getMarketplaceInformation() == null || other.getMarketplaceInformation().equals(this.getMarketplaceInformation());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAddonName() == null ? 0 : this.getAddonName().hashCode());
        hashCode = 31 * hashCode + (this.getClusterName() == null ? 0 : this.getClusterName().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getAddonVersion() == null ? 0 : this.getAddonVersion().hashCode());
        hashCode = 31 * hashCode + (this.getHealth() == null ? 0 : this.getHealth().hashCode());
        hashCode = 31 * hashCode + (this.getAddonArn() == null ? 0 : this.getAddonArn().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getModifiedAt() == null ? 0 : this.getModifiedAt().hashCode());
        hashCode = 31 * hashCode + (this.getServiceAccountRoleArn() == null ? 0 : this.getServiceAccountRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getPublisher() == null ? 0 : this.getPublisher().hashCode());
        hashCode = 31 * hashCode + (this.getOwner() == null ? 0 : this.getOwner().hashCode());
        hashCode = 31 * hashCode + (this.getMarketplaceInformation() == null ? 0 : this.getMarketplaceInformation().hashCode());
        return hashCode;
    }

    public Addon clone() {
        try {
            return (Addon)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AddonMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

