/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.ServiceConnectClientAlias;
import com.amazonaws.services.ecs.model.ServiceConnectTlsConfiguration;
import com.amazonaws.services.ecs.model.TimeoutConfiguration;
import com.amazonaws.services.ecs.model.transform.ServiceConnectServiceMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ServiceConnectService
implements Serializable,
Cloneable,
StructuredPojo {
    private String portName;
    private String discoveryName;
    private SdkInternalList<ServiceConnectClientAlias> clientAliases;
    private Integer ingressPortOverride;
    private TimeoutConfiguration timeout;
    private ServiceConnectTlsConfiguration tls;

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public String getPortName() {
        return this.portName;
    }

    public ServiceConnectService withPortName(String portName) {
        this.setPortName(portName);
        return this;
    }

    public void setDiscoveryName(String discoveryName) {
        this.discoveryName = discoveryName;
    }

    public String getDiscoveryName() {
        return this.discoveryName;
    }

    public ServiceConnectService withDiscoveryName(String discoveryName) {
        this.setDiscoveryName(discoveryName);
        return this;
    }

    public List<ServiceConnectClientAlias> getClientAliases() {
        if (this.clientAliases == null) {
            this.clientAliases = new SdkInternalList();
        }
        return this.clientAliases;
    }

    public void setClientAliases(Collection<ServiceConnectClientAlias> clientAliases) {
        if (clientAliases == null) {
            this.clientAliases = null;
            return;
        }
        this.clientAliases = new SdkInternalList(clientAliases);
    }

    public ServiceConnectService withClientAliases(ServiceConnectClientAlias ... clientAliases) {
        if (this.clientAliases == null) {
            this.setClientAliases((Collection<ServiceConnectClientAlias>)new SdkInternalList(clientAliases.length));
        }
        for (ServiceConnectClientAlias ele : clientAliases) {
            this.clientAliases.add((Object)ele);
        }
        return this;
    }

    public ServiceConnectService withClientAliases(Collection<ServiceConnectClientAlias> clientAliases) {
        this.setClientAliases(clientAliases);
        return this;
    }

    public void setIngressPortOverride(Integer ingressPortOverride) {
        this.ingressPortOverride = ingressPortOverride;
    }

    public Integer getIngressPortOverride() {
        return this.ingressPortOverride;
    }

    public ServiceConnectService withIngressPortOverride(Integer ingressPortOverride) {
        this.setIngressPortOverride(ingressPortOverride);
        return this;
    }

    public void setTimeout(TimeoutConfiguration timeout) {
        this.timeout = timeout;
    }

    public TimeoutConfiguration getTimeout() {
        return this.timeout;
    }

    public ServiceConnectService withTimeout(TimeoutConfiguration timeout) {
        this.setTimeout(timeout);
        return this;
    }

    public void setTls(ServiceConnectTlsConfiguration tls) {
        this.tls = tls;
    }

    public ServiceConnectTlsConfiguration getTls() {
        return this.tls;
    }

    public ServiceConnectService withTls(ServiceConnectTlsConfiguration tls) {
        this.setTls(tls);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPortName() != null) {
            sb.append("PortName: ").append(this.getPortName()).append(",");
        }
        if (this.getDiscoveryName() != null) {
            sb.append("DiscoveryName: ").append(this.getDiscoveryName()).append(",");
        }
        if (this.getClientAliases() != null) {
            sb.append("ClientAliases: ").append(this.getClientAliases()).append(",");
        }
        if (this.getIngressPortOverride() != null) {
            sb.append("IngressPortOverride: ").append(this.getIngressPortOverride()).append(",");
        }
        if (this.getTimeout() != null) {
            sb.append("Timeout: ").append(this.getTimeout()).append(",");
        }
        if (this.getTls() != null) {
            sb.append("Tls: ").append(this.getTls());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceConnectService)) {
            return false;
        }
        ServiceConnectService other = (ServiceConnectService)obj;
        if (other.getPortName() == null ^ this.getPortName() == null) {
            return false;
        }
        if (other.getPortName() != null && !other.getPortName().equals(this.getPortName())) {
            return false;
        }
        if (other.getDiscoveryName() == null ^ this.getDiscoveryName() == null) {
            return false;
        }
        if (other.getDiscoveryName() != null && !other.getDiscoveryName().equals(this.getDiscoveryName())) {
            return false;
        }
        if (other.getClientAliases() == null ^ this.getClientAliases() == null) {
            return false;
        }
        if (other.getClientAliases() != null && !other.getClientAliases().equals(this.getClientAliases())) {
            return false;
        }
        if (other.getIngressPortOverride() == null ^ this.getIngressPortOverride() == null) {
            return false;
        }
        if (other.getIngressPortOverride() != null && !other.getIngressPortOverride().equals(this.getIngressPortOverride())) {
            return false;
        }
        if (other.getTimeout() == null ^ this.getTimeout() == null) {
            return false;
        }
        if (other.getTimeout() != null && !other.getTimeout().equals(this.getTimeout())) {
            return false;
        }
        if (other.getTls() == null ^ this.getTls() == null) {
            return false;
        }
        return other.getTls() == null || other.getTls().equals(this.getTls());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPortName() == null ? 0 : this.getPortName().hashCode());
        hashCode = 31 * hashCode + (this.getDiscoveryName() == null ? 0 : this.getDiscoveryName().hashCode());
        hashCode = 31 * hashCode + (this.getClientAliases() == null ? 0 : this.getClientAliases().hashCode());
        hashCode = 31 * hashCode + (this.getIngressPortOverride() == null ? 0 : this.getIngressPortOverride().hashCode());
        hashCode = 31 * hashCode + (this.getTimeout() == null ? 0 : this.getTimeout().hashCode());
        hashCode = 31 * hashCode + (this.getTls() == null ? 0 : this.getTls().hashCode());
        return hashCode;
    }

    public ServiceConnectService clone() {
        try {
            return (ServiceConnectService)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ServiceConnectServiceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

