/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.Attachment;
import com.amazonaws.services.ecs.model.CapacityProviderStrategyItem;
import com.amazonaws.services.ecs.model.ClusterConfiguration;
import com.amazonaws.services.ecs.model.ClusterServiceConnectDefaults;
import com.amazonaws.services.ecs.model.ClusterSetting;
import com.amazonaws.services.ecs.model.KeyValuePair;
import com.amazonaws.services.ecs.model.Tag;
import com.amazonaws.services.ecs.model.transform.ClusterMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class Cluster
implements Serializable,
Cloneable,
StructuredPojo {
    private String clusterArn;
    private String clusterName;
    private ClusterConfiguration configuration;
    private String status;
    private Integer registeredContainerInstancesCount;
    private Integer runningTasksCount;
    private Integer pendingTasksCount;
    private Integer activeServicesCount;
    private SdkInternalList<KeyValuePair> statistics;
    private SdkInternalList<Tag> tags;
    private SdkInternalList<ClusterSetting> settings;
    private SdkInternalList<String> capacityProviders;
    private SdkInternalList<CapacityProviderStrategyItem> defaultCapacityProviderStrategy;
    private SdkInternalList<Attachment> attachments;
    private String attachmentsStatus;
    private ClusterServiceConnectDefaults serviceConnectDefaults;

    public void setClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
    }

    public String getClusterArn() {
        return this.clusterArn;
    }

    public Cluster withClusterArn(String clusterArn) {
        this.setClusterArn(clusterArn);
        return this;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public Cluster withClusterName(String clusterName) {
        this.setClusterName(clusterName);
        return this;
    }

    public void setConfiguration(ClusterConfiguration configuration) {
        this.configuration = configuration;
    }

    public ClusterConfiguration getConfiguration() {
        return this.configuration;
    }

    public Cluster withConfiguration(ClusterConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Cluster withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setRegisteredContainerInstancesCount(Integer registeredContainerInstancesCount) {
        this.registeredContainerInstancesCount = registeredContainerInstancesCount;
    }

    public Integer getRegisteredContainerInstancesCount() {
        return this.registeredContainerInstancesCount;
    }

    public Cluster withRegisteredContainerInstancesCount(Integer registeredContainerInstancesCount) {
        this.setRegisteredContainerInstancesCount(registeredContainerInstancesCount);
        return this;
    }

    public void setRunningTasksCount(Integer runningTasksCount) {
        this.runningTasksCount = runningTasksCount;
    }

    public Integer getRunningTasksCount() {
        return this.runningTasksCount;
    }

    public Cluster withRunningTasksCount(Integer runningTasksCount) {
        this.setRunningTasksCount(runningTasksCount);
        return this;
    }

    public void setPendingTasksCount(Integer pendingTasksCount) {
        this.pendingTasksCount = pendingTasksCount;
    }

    public Integer getPendingTasksCount() {
        return this.pendingTasksCount;
    }

    public Cluster withPendingTasksCount(Integer pendingTasksCount) {
        this.setPendingTasksCount(pendingTasksCount);
        return this;
    }

    public void setActiveServicesCount(Integer activeServicesCount) {
        this.activeServicesCount = activeServicesCount;
    }

    public Integer getActiveServicesCount() {
        return this.activeServicesCount;
    }

    public Cluster withActiveServicesCount(Integer activeServicesCount) {
        this.setActiveServicesCount(activeServicesCount);
        return this;
    }

    public List<KeyValuePair> getStatistics() {
        if (this.statistics == null) {
            this.statistics = new SdkInternalList();
        }
        return this.statistics;
    }

    public void setStatistics(Collection<KeyValuePair> statistics) {
        if (statistics == null) {
            this.statistics = null;
            return;
        }
        this.statistics = new SdkInternalList(statistics);
    }

    public Cluster withStatistics(KeyValuePair ... statistics) {
        if (this.statistics == null) {
            this.setStatistics((Collection<KeyValuePair>)new SdkInternalList(statistics.length));
        }
        for (KeyValuePair ele : statistics) {
            this.statistics.add((Object)ele);
        }
        return this;
    }

    public Cluster withStatistics(Collection<KeyValuePair> statistics) {
        this.setStatistics(statistics);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public Cluster withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public Cluster withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public List<ClusterSetting> getSettings() {
        if (this.settings == null) {
            this.settings = new SdkInternalList();
        }
        return this.settings;
    }

    public void setSettings(Collection<ClusterSetting> settings) {
        if (settings == null) {
            this.settings = null;
            return;
        }
        this.settings = new SdkInternalList(settings);
    }

    public Cluster withSettings(ClusterSetting ... settings) {
        if (this.settings == null) {
            this.setSettings((Collection<ClusterSetting>)new SdkInternalList(settings.length));
        }
        for (ClusterSetting ele : settings) {
            this.settings.add((Object)ele);
        }
        return this;
    }

    public Cluster withSettings(Collection<ClusterSetting> settings) {
        this.setSettings(settings);
        return this;
    }

    public List<String> getCapacityProviders() {
        if (this.capacityProviders == null) {
            this.capacityProviders = new SdkInternalList();
        }
        return this.capacityProviders;
    }

    public void setCapacityProviders(Collection<String> capacityProviders) {
        if (capacityProviders == null) {
            this.capacityProviders = null;
            return;
        }
        this.capacityProviders = new SdkInternalList(capacityProviders);
    }

    public Cluster withCapacityProviders(String ... capacityProviders) {
        if (this.capacityProviders == null) {
            this.setCapacityProviders((Collection<String>)new SdkInternalList(capacityProviders.length));
        }
        for (String ele : capacityProviders) {
            this.capacityProviders.add((Object)ele);
        }
        return this;
    }

    public Cluster withCapacityProviders(Collection<String> capacityProviders) {
        this.setCapacityProviders(capacityProviders);
        return this;
    }

    public List<CapacityProviderStrategyItem> getDefaultCapacityProviderStrategy() {
        if (this.defaultCapacityProviderStrategy == null) {
            this.defaultCapacityProviderStrategy = new SdkInternalList();
        }
        return this.defaultCapacityProviderStrategy;
    }

    public void setDefaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem> defaultCapacityProviderStrategy) {
        if (defaultCapacityProviderStrategy == null) {
            this.defaultCapacityProviderStrategy = null;
            return;
        }
        this.defaultCapacityProviderStrategy = new SdkInternalList(defaultCapacityProviderStrategy);
    }

    public Cluster withDefaultCapacityProviderStrategy(CapacityProviderStrategyItem ... defaultCapacityProviderStrategy) {
        if (this.defaultCapacityProviderStrategy == null) {
            this.setDefaultCapacityProviderStrategy((Collection<CapacityProviderStrategyItem>)new SdkInternalList(defaultCapacityProviderStrategy.length));
        }
        for (CapacityProviderStrategyItem ele : defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy.add((Object)ele);
        }
        return this;
    }

    public Cluster withDefaultCapacityProviderStrategy(Collection<CapacityProviderStrategyItem> defaultCapacityProviderStrategy) {
        this.setDefaultCapacityProviderStrategy(defaultCapacityProviderStrategy);
        return this;
    }

    public List<Attachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new SdkInternalList();
        }
        return this.attachments;
    }

    public void setAttachments(Collection<Attachment> attachments) {
        if (attachments == null) {
            this.attachments = null;
            return;
        }
        this.attachments = new SdkInternalList(attachments);
    }

    public Cluster withAttachments(Attachment ... attachments) {
        if (this.attachments == null) {
            this.setAttachments((Collection<Attachment>)new SdkInternalList(attachments.length));
        }
        for (Attachment ele : attachments) {
            this.attachments.add((Object)ele);
        }
        return this;
    }

    public Cluster withAttachments(Collection<Attachment> attachments) {
        this.setAttachments(attachments);
        return this;
    }

    public void setAttachmentsStatus(String attachmentsStatus) {
        this.attachmentsStatus = attachmentsStatus;
    }

    public String getAttachmentsStatus() {
        return this.attachmentsStatus;
    }

    public Cluster withAttachmentsStatus(String attachmentsStatus) {
        this.setAttachmentsStatus(attachmentsStatus);
        return this;
    }

    public void setServiceConnectDefaults(ClusterServiceConnectDefaults serviceConnectDefaults) {
        this.serviceConnectDefaults = serviceConnectDefaults;
    }

    public ClusterServiceConnectDefaults getServiceConnectDefaults() {
        return this.serviceConnectDefaults;
    }

    public Cluster withServiceConnectDefaults(ClusterServiceConnectDefaults serviceConnectDefaults) {
        this.setServiceConnectDefaults(serviceConnectDefaults);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterArn() != null) {
            sb.append("ClusterArn: ").append(this.getClusterArn()).append(",");
        }
        if (this.getClusterName() != null) {
            sb.append("ClusterName: ").append(this.getClusterName()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getRegisteredContainerInstancesCount() != null) {
            sb.append("RegisteredContainerInstancesCount: ").append(this.getRegisteredContainerInstancesCount()).append(",");
        }
        if (this.getRunningTasksCount() != null) {
            sb.append("RunningTasksCount: ").append(this.getRunningTasksCount()).append(",");
        }
        if (this.getPendingTasksCount() != null) {
            sb.append("PendingTasksCount: ").append(this.getPendingTasksCount()).append(",");
        }
        if (this.getActiveServicesCount() != null) {
            sb.append("ActiveServicesCount: ").append(this.getActiveServicesCount()).append(",");
        }
        if (this.getStatistics() != null) {
            sb.append("Statistics: ").append(this.getStatistics()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getSettings() != null) {
            sb.append("Settings: ").append(this.getSettings()).append(",");
        }
        if (this.getCapacityProviders() != null) {
            sb.append("CapacityProviders: ").append(this.getCapacityProviders()).append(",");
        }
        if (this.getDefaultCapacityProviderStrategy() != null) {
            sb.append("DefaultCapacityProviderStrategy: ").append(this.getDefaultCapacityProviderStrategy()).append(",");
        }
        if (this.getAttachments() != null) {
            sb.append("Attachments: ").append(this.getAttachments()).append(",");
        }
        if (this.getAttachmentsStatus() != null) {
            sb.append("AttachmentsStatus: ").append(this.getAttachmentsStatus()).append(",");
        }
        if (this.getServiceConnectDefaults() != null) {
            sb.append("ServiceConnectDefaults: ").append(this.getServiceConnectDefaults());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        if (other.getClusterArn() == null ^ this.getClusterArn() == null) {
            return false;
        }
        if (other.getClusterArn() != null && !other.getClusterArn().equals(this.getClusterArn())) {
            return false;
        }
        if (other.getClusterName() == null ^ this.getClusterName() == null) {
            return false;
        }
        if (other.getClusterName() != null && !other.getClusterName().equals(this.getClusterName())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getRegisteredContainerInstancesCount() == null ^ this.getRegisteredContainerInstancesCount() == null) {
            return false;
        }
        if (other.getRegisteredContainerInstancesCount() != null && !other.getRegisteredContainerInstancesCount().equals(this.getRegisteredContainerInstancesCount())) {
            return false;
        }
        if (other.getRunningTasksCount() == null ^ this.getRunningTasksCount() == null) {
            return false;
        }
        if (other.getRunningTasksCount() != null && !other.getRunningTasksCount().equals(this.getRunningTasksCount())) {
            return false;
        }
        if (other.getPendingTasksCount() == null ^ this.getPendingTasksCount() == null) {
            return false;
        }
        if (other.getPendingTasksCount() != null && !other.getPendingTasksCount().equals(this.getPendingTasksCount())) {
            return false;
        }
        if (other.getActiveServicesCount() == null ^ this.getActiveServicesCount() == null) {
            return false;
        }
        if (other.getActiveServicesCount() != null && !other.getActiveServicesCount().equals(this.getActiveServicesCount())) {
            return false;
        }
        if (other.getStatistics() == null ^ this.getStatistics() == null) {
            return false;
        }
        if (other.getStatistics() != null && !other.getStatistics().equals(this.getStatistics())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getSettings() == null ^ this.getSettings() == null) {
            return false;
        }
        if (other.getSettings() != null && !other.getSettings().equals(this.getSettings())) {
            return false;
        }
        if (other.getCapacityProviders() == null ^ this.getCapacityProviders() == null) {
            return false;
        }
        if (other.getCapacityProviders() != null && !other.getCapacityProviders().equals(this.getCapacityProviders())) {
            return false;
        }
        if (other.getDefaultCapacityProviderStrategy() == null ^ this.getDefaultCapacityProviderStrategy() == null) {
            return false;
        }
        if (other.getDefaultCapacityProviderStrategy() != null && !other.getDefaultCapacityProviderStrategy().equals(this.getDefaultCapacityProviderStrategy())) {
            return false;
        }
        if (other.getAttachments() == null ^ this.getAttachments() == null) {
            return false;
        }
        if (other.getAttachments() != null && !other.getAttachments().equals(this.getAttachments())) {
            return false;
        }
        if (other.getAttachmentsStatus() == null ^ this.getAttachmentsStatus() == null) {
            return false;
        }
        if (other.getAttachmentsStatus() != null && !other.getAttachmentsStatus().equals(this.getAttachmentsStatus())) {
            return false;
        }
        if (other.getServiceConnectDefaults() == null ^ this.getServiceConnectDefaults() == null) {
            return false;
        }
        return other.getServiceConnectDefaults() == null || other.getServiceConnectDefaults().equals(this.getServiceConnectDefaults());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterArn() == null ? 0 : this.getClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getClusterName() == null ? 0 : this.getClusterName().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getRegisteredContainerInstancesCount() == null ? 0 : this.getRegisteredContainerInstancesCount().hashCode());
        hashCode = 31 * hashCode + (this.getRunningTasksCount() == null ? 0 : this.getRunningTasksCount().hashCode());
        hashCode = 31 * hashCode + (this.getPendingTasksCount() == null ? 0 : this.getPendingTasksCount().hashCode());
        hashCode = 31 * hashCode + (this.getActiveServicesCount() == null ? 0 : this.getActiveServicesCount().hashCode());
        hashCode = 31 * hashCode + (this.getStatistics() == null ? 0 : this.getStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getSettings() == null ? 0 : this.getSettings().hashCode());
        hashCode = 31 * hashCode + (this.getCapacityProviders() == null ? 0 : this.getCapacityProviders().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultCapacityProviderStrategy() == null ? 0 : this.getDefaultCapacityProviderStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getAttachments() == null ? 0 : this.getAttachments().hashCode());
        hashCode = 31 * hashCode + (this.getAttachmentsStatus() == null ? 0 : this.getAttachmentsStatus().hashCode());
        hashCode = 31 * hashCode + (this.getServiceConnectDefaults() == null ? 0 : this.getServiceConnectDefaults().hashCode());
        return hashCode;
    }

    public Cluster clone() {
        try {
            return (Cluster)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

