/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.ListAttributesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListAttributesRequestMarshaller
implements Marshaller<Request<ListAttributesRequest>, ListAttributesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListAttributesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListAttributesRequest> marshall(ListAttributesRequest listAttributesRequest) {
        if (listAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listAttributesRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.ListAttributes");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listAttributesRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(listAttributesRequest.getCluster());
            }
            if (listAttributesRequest.getTargetType() != null) {
                jsonGenerator.writeFieldName("targetType").writeValue(listAttributesRequest.getTargetType());
            }
            if (listAttributesRequest.getAttributeName() != null) {
                jsonGenerator.writeFieldName("attributeName").writeValue(listAttributesRequest.getAttributeName());
            }
            if (listAttributesRequest.getAttributeValue() != null) {
                jsonGenerator.writeFieldName("attributeValue").writeValue(listAttributesRequest.getAttributeValue());
            }
            if (listAttributesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(listAttributesRequest.getNextToken());
            }
            if (listAttributesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(listAttributesRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

