/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.KeyValuePair;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ContainerOverride
implements Serializable,
Cloneable {
    private String name;
    private SdkInternalList<String> command;
    private SdkInternalList<KeyValuePair> environment;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public ContainerOverride withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getCommand() {
        if (this.command == null) {
            this.command = new SdkInternalList();
        }
        return this.command;
    }

    public void setCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
            return;
        }
        this.command = new SdkInternalList(command);
    }

    public ContainerOverride withCommand(String ... command) {
        if (this.command == null) {
            this.setCommand((Collection<String>)new SdkInternalList(command.length));
        }
        for (String ele : command) {
            this.command.add((Object)ele);
        }
        return this;
    }

    public ContainerOverride withCommand(Collection<String> command) {
        this.setCommand(command);
        return this;
    }

    public List<KeyValuePair> getEnvironment() {
        if (this.environment == null) {
            this.environment = new SdkInternalList();
        }
        return this.environment;
    }

    public void setEnvironment(Collection<KeyValuePair> environment) {
        if (environment == null) {
            this.environment = null;
            return;
        }
        this.environment = new SdkInternalList(environment);
    }

    public ContainerOverride withEnvironment(KeyValuePair ... environment) {
        if (this.environment == null) {
            this.setEnvironment((Collection<KeyValuePair>)new SdkInternalList(environment.length));
        }
        for (KeyValuePair ele : environment) {
            this.environment.add((Object)ele);
        }
        return this;
    }

    public ContainerOverride withEnvironment(Collection<KeyValuePair> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getCommand() != null) {
            sb.append("Command: ").append(this.getCommand()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerOverride)) {
            return false;
        }
        ContainerOverride other = (ContainerOverride)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        return other.getEnvironment() == null || other.getEnvironment().equals(this.getEnvironment());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        return hashCode;
    }

    public ContainerOverride clone() {
        try {
            return (ContainerOverride)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

