/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ecr.model.ImageIdentifier;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchGetImageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String registryId;
    private String repositoryName;
    private List<ImageIdentifier> imageIds;
    private List<String> acceptedMediaTypes;

    public void setRegistryId(String registryId) {
        this.registryId = registryId;
    }

    public String getRegistryId() {
        return this.registryId;
    }

    public BatchGetImageRequest withRegistryId(String registryId) {
        this.setRegistryId(registryId);
        return this;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public BatchGetImageRequest withRepositoryName(String repositoryName) {
        this.setRepositoryName(repositoryName);
        return this;
    }

    public List<ImageIdentifier> getImageIds() {
        return this.imageIds;
    }

    public void setImageIds(Collection<ImageIdentifier> imageIds) {
        if (imageIds == null) {
            this.imageIds = null;
            return;
        }
        this.imageIds = new ArrayList<ImageIdentifier>(imageIds);
    }

    public BatchGetImageRequest withImageIds(ImageIdentifier ... imageIds) {
        if (this.imageIds == null) {
            this.setImageIds(new ArrayList<ImageIdentifier>(imageIds.length));
        }
        for (ImageIdentifier ele : imageIds) {
            this.imageIds.add(ele);
        }
        return this;
    }

    public BatchGetImageRequest withImageIds(Collection<ImageIdentifier> imageIds) {
        this.setImageIds(imageIds);
        return this;
    }

    public List<String> getAcceptedMediaTypes() {
        return this.acceptedMediaTypes;
    }

    public void setAcceptedMediaTypes(Collection<String> acceptedMediaTypes) {
        if (acceptedMediaTypes == null) {
            this.acceptedMediaTypes = null;
            return;
        }
        this.acceptedMediaTypes = new ArrayList<String>(acceptedMediaTypes);
    }

    public BatchGetImageRequest withAcceptedMediaTypes(String ... acceptedMediaTypes) {
        if (this.acceptedMediaTypes == null) {
            this.setAcceptedMediaTypes(new ArrayList<String>(acceptedMediaTypes.length));
        }
        for (String ele : acceptedMediaTypes) {
            this.acceptedMediaTypes.add(ele);
        }
        return this;
    }

    public BatchGetImageRequest withAcceptedMediaTypes(Collection<String> acceptedMediaTypes) {
        this.setAcceptedMediaTypes(acceptedMediaTypes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRegistryId() != null) {
            sb.append("RegistryId: ").append(this.getRegistryId()).append(",");
        }
        if (this.getRepositoryName() != null) {
            sb.append("RepositoryName: ").append(this.getRepositoryName()).append(",");
        }
        if (this.getImageIds() != null) {
            sb.append("ImageIds: ").append(this.getImageIds()).append(",");
        }
        if (this.getAcceptedMediaTypes() != null) {
            sb.append("AcceptedMediaTypes: ").append(this.getAcceptedMediaTypes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetImageRequest)) {
            return false;
        }
        BatchGetImageRequest other = (BatchGetImageRequest)obj;
        if (other.getRegistryId() == null ^ this.getRegistryId() == null) {
            return false;
        }
        if (other.getRegistryId() != null && !other.getRegistryId().equals(this.getRegistryId())) {
            return false;
        }
        if (other.getRepositoryName() == null ^ this.getRepositoryName() == null) {
            return false;
        }
        if (other.getRepositoryName() != null && !other.getRepositoryName().equals(this.getRepositoryName())) {
            return false;
        }
        if (other.getImageIds() == null ^ this.getImageIds() == null) {
            return false;
        }
        if (other.getImageIds() != null && !other.getImageIds().equals(this.getImageIds())) {
            return false;
        }
        if (other.getAcceptedMediaTypes() == null ^ this.getAcceptedMediaTypes() == null) {
            return false;
        }
        return other.getAcceptedMediaTypes() == null || other.getAcceptedMediaTypes().equals(this.getAcceptedMediaTypes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRegistryId() == null ? 0 : this.getRegistryId().hashCode());
        hashCode = 31 * hashCode + (this.getRepositoryName() == null ? 0 : this.getRepositoryName().hashCode());
        hashCode = 31 * hashCode + (this.getImageIds() == null ? 0 : this.getImageIds().hashCode());
        hashCode = 31 * hashCode + (this.getAcceptedMediaTypes() == null ? 0 : this.getAcceptedMediaTypes().hashCode());
        return hashCode;
    }

    public BatchGetImageRequest clone() {
        return (BatchGetImageRequest)super.clone();
    }
}

