/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecr.model.ScanFrequency;
import com.amazonaws.services.ecr.model.ScanningRepositoryFilter;
import com.amazonaws.services.ecr.model.transform.RepositoryScanningConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RepositoryScanningConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String repositoryArn;
    private String repositoryName;
    private Boolean scanOnPush;
    private String scanFrequency;
    private List<ScanningRepositoryFilter> appliedScanFilters;

    public void setRepositoryArn(String repositoryArn) {
        this.repositoryArn = repositoryArn;
    }

    public String getRepositoryArn() {
        return this.repositoryArn;
    }

    public RepositoryScanningConfiguration withRepositoryArn(String repositoryArn) {
        this.setRepositoryArn(repositoryArn);
        return this;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public RepositoryScanningConfiguration withRepositoryName(String repositoryName) {
        this.setRepositoryName(repositoryName);
        return this;
    }

    public void setScanOnPush(Boolean scanOnPush) {
        this.scanOnPush = scanOnPush;
    }

    public Boolean getScanOnPush() {
        return this.scanOnPush;
    }

    public RepositoryScanningConfiguration withScanOnPush(Boolean scanOnPush) {
        this.setScanOnPush(scanOnPush);
        return this;
    }

    public Boolean isScanOnPush() {
        return this.scanOnPush;
    }

    public void setScanFrequency(String scanFrequency) {
        this.scanFrequency = scanFrequency;
    }

    public String getScanFrequency() {
        return this.scanFrequency;
    }

    public RepositoryScanningConfiguration withScanFrequency(String scanFrequency) {
        this.setScanFrequency(scanFrequency);
        return this;
    }

    public RepositoryScanningConfiguration withScanFrequency(ScanFrequency scanFrequency) {
        this.scanFrequency = scanFrequency.toString();
        return this;
    }

    public List<ScanningRepositoryFilter> getAppliedScanFilters() {
        return this.appliedScanFilters;
    }

    public void setAppliedScanFilters(Collection<ScanningRepositoryFilter> appliedScanFilters) {
        if (appliedScanFilters == null) {
            this.appliedScanFilters = null;
            return;
        }
        this.appliedScanFilters = new ArrayList<ScanningRepositoryFilter>(appliedScanFilters);
    }

    public RepositoryScanningConfiguration withAppliedScanFilters(ScanningRepositoryFilter ... appliedScanFilters) {
        if (this.appliedScanFilters == null) {
            this.setAppliedScanFilters(new ArrayList<ScanningRepositoryFilter>(appliedScanFilters.length));
        }
        for (ScanningRepositoryFilter ele : appliedScanFilters) {
            this.appliedScanFilters.add(ele);
        }
        return this;
    }

    public RepositoryScanningConfiguration withAppliedScanFilters(Collection<ScanningRepositoryFilter> appliedScanFilters) {
        this.setAppliedScanFilters(appliedScanFilters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRepositoryArn() != null) {
            sb.append("RepositoryArn: ").append(this.getRepositoryArn()).append(",");
        }
        if (this.getRepositoryName() != null) {
            sb.append("RepositoryName: ").append(this.getRepositoryName()).append(",");
        }
        if (this.getScanOnPush() != null) {
            sb.append("ScanOnPush: ").append(this.getScanOnPush()).append(",");
        }
        if (this.getScanFrequency() != null) {
            sb.append("ScanFrequency: ").append(this.getScanFrequency()).append(",");
        }
        if (this.getAppliedScanFilters() != null) {
            sb.append("AppliedScanFilters: ").append(this.getAppliedScanFilters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RepositoryScanningConfiguration)) {
            return false;
        }
        RepositoryScanningConfiguration other = (RepositoryScanningConfiguration)obj;
        if (other.getRepositoryArn() == null ^ this.getRepositoryArn() == null) {
            return false;
        }
        if (other.getRepositoryArn() != null && !other.getRepositoryArn().equals(this.getRepositoryArn())) {
            return false;
        }
        if (other.getRepositoryName() == null ^ this.getRepositoryName() == null) {
            return false;
        }
        if (other.getRepositoryName() != null && !other.getRepositoryName().equals(this.getRepositoryName())) {
            return false;
        }
        if (other.getScanOnPush() == null ^ this.getScanOnPush() == null) {
            return false;
        }
        if (other.getScanOnPush() != null && !other.getScanOnPush().equals(this.getScanOnPush())) {
            return false;
        }
        if (other.getScanFrequency() == null ^ this.getScanFrequency() == null) {
            return false;
        }
        if (other.getScanFrequency() != null && !other.getScanFrequency().equals(this.getScanFrequency())) {
            return false;
        }
        if (other.getAppliedScanFilters() == null ^ this.getAppliedScanFilters() == null) {
            return false;
        }
        return other.getAppliedScanFilters() == null || other.getAppliedScanFilters().equals(this.getAppliedScanFilters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRepositoryArn() == null ? 0 : this.getRepositoryArn().hashCode());
        hashCode = 31 * hashCode + (this.getRepositoryName() == null ? 0 : this.getRepositoryName().hashCode());
        hashCode = 31 * hashCode + (this.getScanOnPush() == null ? 0 : this.getScanOnPush().hashCode());
        hashCode = 31 * hashCode + (this.getScanFrequency() == null ? 0 : this.getScanFrequency().hashCode());
        hashCode = 31 * hashCode + (this.getAppliedScanFilters() == null ? 0 : this.getAppliedScanFilters().hashCode());
        return hashCode;
    }

    public RepositoryScanningConfiguration clone() {
        try {
            return (RepositoryScanningConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RepositoryScanningConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

