/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ModifyVerifiedAccessInstanceLoggingConfigurationRequest;
import com.amazonaws.services.ec2.model.VerifiedAccessLogCloudWatchLogsDestinationOptions;
import com.amazonaws.services.ec2.model.VerifiedAccessLogKinesisDataFirehoseDestinationOptions;
import com.amazonaws.services.ec2.model.VerifiedAccessLogOptions;
import com.amazonaws.services.ec2.model.VerifiedAccessLogS3DestinationOptions;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class ModifyVerifiedAccessInstanceLoggingConfigurationRequestMarshaller
implements Marshaller<Request<ModifyVerifiedAccessInstanceLoggingConfigurationRequest>, ModifyVerifiedAccessInstanceLoggingConfigurationRequest> {
    public Request<ModifyVerifiedAccessInstanceLoggingConfigurationRequest> marshall(ModifyVerifiedAccessInstanceLoggingConfigurationRequest modifyVerifiedAccessInstanceLoggingConfigurationRequest) {
        VerifiedAccessLogOptions accessLogs;
        if (modifyVerifiedAccessInstanceLoggingConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVerifiedAccessInstanceLoggingConfigurationRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVerifiedAccessInstanceLoggingConfiguration");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVerifiedAccessInstanceLoggingConfigurationRequest.getVerifiedAccessInstanceId() != null) {
            request.addParameter("VerifiedAccessInstanceId", StringUtils.fromString((String)modifyVerifiedAccessInstanceLoggingConfigurationRequest.getVerifiedAccessInstanceId()));
        }
        if ((accessLogs = modifyVerifiedAccessInstanceLoggingConfigurationRequest.getAccessLogs()) != null) {
            VerifiedAccessLogKinesisDataFirehoseDestinationOptions kinesisDataFirehose;
            VerifiedAccessLogCloudWatchLogsDestinationOptions cloudWatchLogs;
            VerifiedAccessLogS3DestinationOptions s3 = accessLogs.getS3();
            if (s3 != null) {
                if (s3.getEnabled() != null) {
                    request.addParameter("AccessLogs.S3.Enabled", StringUtils.fromBoolean((Boolean)s3.getEnabled()));
                }
                if (s3.getBucketName() != null) {
                    request.addParameter("AccessLogs.S3.BucketName", StringUtils.fromString((String)s3.getBucketName()));
                }
                if (s3.getPrefix() != null) {
                    request.addParameter("AccessLogs.S3.Prefix", StringUtils.fromString((String)s3.getPrefix()));
                }
                if (s3.getBucketOwner() != null) {
                    request.addParameter("AccessLogs.S3.BucketOwner", StringUtils.fromString((String)s3.getBucketOwner()));
                }
            }
            if ((cloudWatchLogs = accessLogs.getCloudWatchLogs()) != null) {
                if (cloudWatchLogs.getEnabled() != null) {
                    request.addParameter("AccessLogs.CloudWatchLogs.Enabled", StringUtils.fromBoolean((Boolean)cloudWatchLogs.getEnabled()));
                }
                if (cloudWatchLogs.getLogGroup() != null) {
                    request.addParameter("AccessLogs.CloudWatchLogs.LogGroup", StringUtils.fromString((String)cloudWatchLogs.getLogGroup()));
                }
            }
            if ((kinesisDataFirehose = accessLogs.getKinesisDataFirehose()) != null) {
                if (kinesisDataFirehose.getEnabled() != null) {
                    request.addParameter("AccessLogs.KinesisDataFirehose.Enabled", StringUtils.fromBoolean((Boolean)kinesisDataFirehose.getEnabled()));
                }
                if (kinesisDataFirehose.getDeliveryStream() != null) {
                    request.addParameter("AccessLogs.KinesisDataFirehose.DeliveryStream", StringUtils.fromString((String)kinesisDataFirehose.getDeliveryStream()));
                }
            }
            if (accessLogs.getLogVersion() != null) {
                request.addParameter("AccessLogs.LogVersion", StringUtils.fromString((String)accessLogs.getLogVersion()));
            }
            if (accessLogs.getIncludeTrustContext() != null) {
                request.addParameter("AccessLogs.IncludeTrustContext", StringUtils.fromBoolean((Boolean)accessLogs.getIncludeTrustContext()));
            }
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)modifyVerifiedAccessInstanceLoggingConfigurationRequest.getClientToken()));
        return request;
    }
}

