/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.MediaDeviceMemoryInfo;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class MediaDeviceMemoryInfoStaxUnmarshaller
implements Unmarshaller<MediaDeviceMemoryInfo, StaxUnmarshallerContext> {
    private static MediaDeviceMemoryInfoStaxUnmarshaller instance;

    public MediaDeviceMemoryInfo unmarshall(StaxUnmarshallerContext context) throws Exception {
        MediaDeviceMemoryInfo mediaDeviceMemoryInfo = new MediaDeviceMemoryInfo();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return mediaDeviceMemoryInfo;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (!context.testExpression("sizeInMiB", targetDepth)) continue;
                mediaDeviceMemoryInfo.setSizeInMiB(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return mediaDeviceMemoryInfo;
    }

    public static MediaDeviceMemoryInfoStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new MediaDeviceMemoryInfoStaxUnmarshaller();
        }
        return instance;
    }
}

