/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification;
import com.amazonaws.services.ec2.model.transform.CreateVpnConnectionRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateVpnConnectionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateVpnConnectionRequest> {
    private String customerGatewayId;
    private String type;
    private String vpnGatewayId;
    private String transitGatewayId;
    private VpnConnectionOptionsSpecification options;
    private SdkInternalList<TagSpecification> tagSpecifications;

    public CreateVpnConnectionRequest() {
    }

    public CreateVpnConnectionRequest(String type, String customerGatewayId, String vpnGatewayId) {
        this.setType(type);
        this.setCustomerGatewayId(customerGatewayId);
        this.setVpnGatewayId(vpnGatewayId);
    }

    public void setCustomerGatewayId(String customerGatewayId) {
        this.customerGatewayId = customerGatewayId;
    }

    public String getCustomerGatewayId() {
        return this.customerGatewayId;
    }

    public CreateVpnConnectionRequest withCustomerGatewayId(String customerGatewayId) {
        this.setCustomerGatewayId(customerGatewayId);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateVpnConnectionRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public void setVpnGatewayId(String vpnGatewayId) {
        this.vpnGatewayId = vpnGatewayId;
    }

    public String getVpnGatewayId() {
        return this.vpnGatewayId;
    }

    public CreateVpnConnectionRequest withVpnGatewayId(String vpnGatewayId) {
        this.setVpnGatewayId(vpnGatewayId);
        return this;
    }

    public void setTransitGatewayId(String transitGatewayId) {
        this.transitGatewayId = transitGatewayId;
    }

    public String getTransitGatewayId() {
        return this.transitGatewayId;
    }

    public CreateVpnConnectionRequest withTransitGatewayId(String transitGatewayId) {
        this.setTransitGatewayId(transitGatewayId);
        return this;
    }

    public void setOptions(VpnConnectionOptionsSpecification options) {
        this.options = options;
    }

    public VpnConnectionOptionsSpecification getOptions() {
        return this.options;
    }

    public CreateVpnConnectionRequest withOptions(VpnConnectionOptionsSpecification options) {
        this.setOptions(options);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public CreateVpnConnectionRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateVpnConnectionRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    @Override
    public Request<CreateVpnConnectionRequest> getDryRunRequest() {
        Request<CreateVpnConnectionRequest> request = new CreateVpnConnectionRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCustomerGatewayId() != null) {
            sb.append("CustomerGatewayId: ").append(this.getCustomerGatewayId()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getVpnGatewayId() != null) {
            sb.append("VpnGatewayId: ").append(this.getVpnGatewayId()).append(",");
        }
        if (this.getTransitGatewayId() != null) {
            sb.append("TransitGatewayId: ").append(this.getTransitGatewayId()).append(",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpnConnectionRequest)) {
            return false;
        }
        CreateVpnConnectionRequest other = (CreateVpnConnectionRequest)obj;
        if (other.getCustomerGatewayId() == null ^ this.getCustomerGatewayId() == null) {
            return false;
        }
        if (other.getCustomerGatewayId() != null && !other.getCustomerGatewayId().equals(this.getCustomerGatewayId())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getVpnGatewayId() == null ^ this.getVpnGatewayId() == null) {
            return false;
        }
        if (other.getVpnGatewayId() != null && !other.getVpnGatewayId().equals(this.getVpnGatewayId())) {
            return false;
        }
        if (other.getTransitGatewayId() == null ^ this.getTransitGatewayId() == null) {
            return false;
        }
        if (other.getTransitGatewayId() != null && !other.getTransitGatewayId().equals(this.getTransitGatewayId())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        if (other.getOptions() != null && !other.getOptions().equals(this.getOptions())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        return other.getTagSpecifications() == null || other.getTagSpecifications().equals(this.getTagSpecifications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCustomerGatewayId() == null ? 0 : this.getCustomerGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getVpnGatewayId() == null ? 0 : this.getVpnGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.getTransitGatewayId() == null ? 0 : this.getTransitGatewayId().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        return hashCode;
    }

    public CreateVpnConnectionRequest clone() {
        return (CreateVpnConnectionRequest)super.clone();
    }
}

