/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.IpamCidrAuthorizationContext;
import com.amazonaws.services.ec2.model.ProvisionIpamPoolCidrRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class ProvisionIpamPoolCidrRequestMarshaller
implements Marshaller<Request<ProvisionIpamPoolCidrRequest>, ProvisionIpamPoolCidrRequest> {
    public Request<ProvisionIpamPoolCidrRequest> marshall(ProvisionIpamPoolCidrRequest provisionIpamPoolCidrRequest) {
        IpamCidrAuthorizationContext cidrAuthorizationContext;
        if (provisionIpamPoolCidrRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)provisionIpamPoolCidrRequest, "AmazonEC2");
        request.addParameter("Action", "ProvisionIpamPoolCidr");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (provisionIpamPoolCidrRequest.getIpamPoolId() != null) {
            request.addParameter("IpamPoolId", StringUtils.fromString((String)provisionIpamPoolCidrRequest.getIpamPoolId()));
        }
        if (provisionIpamPoolCidrRequest.getCidr() != null) {
            request.addParameter("Cidr", StringUtils.fromString((String)provisionIpamPoolCidrRequest.getCidr()));
        }
        if ((cidrAuthorizationContext = provisionIpamPoolCidrRequest.getCidrAuthorizationContext()) != null) {
            if (cidrAuthorizationContext.getMessage() != null) {
                request.addParameter("CidrAuthorizationContext.Message", StringUtils.fromString((String)cidrAuthorizationContext.getMessage()));
            }
            if (cidrAuthorizationContext.getSignature() != null) {
                request.addParameter("CidrAuthorizationContext.Signature", StringUtils.fromString((String)cidrAuthorizationContext.getSignature()));
            }
        }
        if (provisionIpamPoolCidrRequest.getNetmaskLength() != null) {
            request.addParameter("NetmaskLength", StringUtils.fromInteger((Integer)provisionIpamPoolCidrRequest.getNetmaskLength()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)provisionIpamPoolCidrRequest.getClientToken()));
        return request;
    }
}

