/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.EbsBlockDevice;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceIpv6Address;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.Ipv4PrefixSpecificationRequest;
import com.amazonaws.services.ec2.model.Ipv6PrefixSpecificationRequest;
import com.amazonaws.services.ec2.model.LaunchSpecification;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.services.ec2.model.RequestSpotInstancesRequest;
import com.amazonaws.services.ec2.model.SpotPlacement;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.Iterator;

public class RequestSpotInstancesRequestMarshaller
implements Marshaller<Request<RequestSpotInstancesRequest>, RequestSpotInstancesRequest> {
    public Request<RequestSpotInstancesRequest> marshall(RequestSpotInstancesRequest requestSpotInstancesRequest) {
        SdkInternalList requestSpotInstancesRequestTagSpecificationsList;
        LaunchSpecification launchSpecification;
        if (requestSpotInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)requestSpotInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RequestSpotInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (requestSpotInstancesRequest.getAvailabilityZoneGroup() != null) {
            request.addParameter("AvailabilityZoneGroup", StringUtils.fromString((String)requestSpotInstancesRequest.getAvailabilityZoneGroup()));
        }
        if (requestSpotInstancesRequest.getBlockDurationMinutes() != null) {
            request.addParameter("BlockDurationMinutes", StringUtils.fromInteger((Integer)requestSpotInstancesRequest.getBlockDurationMinutes()));
        }
        if (requestSpotInstancesRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)requestSpotInstancesRequest.getClientToken()));
        }
        if (requestSpotInstancesRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)requestSpotInstancesRequest.getInstanceCount()));
        }
        if (requestSpotInstancesRequest.getLaunchGroup() != null) {
            request.addParameter("LaunchGroup", StringUtils.fromString((String)requestSpotInstancesRequest.getLaunchGroup()));
        }
        if ((launchSpecification = requestSpotInstancesRequest.getLaunchSpecification()) != null) {
            SdkInternalList launchSpecificationSecurityGroupsList;
            SdkInternalList launchSpecificationAllSecurityGroupsList;
            SpotPlacement placement;
            SdkInternalList launchSpecificationNetworkInterfacesList;
            IamInstanceProfileSpecification iamInstanceProfile;
            SdkInternalList launchSpecificationBlockDeviceMappingsList;
            if (launchSpecification.getUserData() != null) {
                request.addParameter("LaunchSpecification.UserData", StringUtils.fromString((String)launchSpecification.getUserData()));
            }
            if (launchSpecification.getAddressingType() != null) {
                request.addParameter("LaunchSpecification.AddressingType", StringUtils.fromString((String)launchSpecification.getAddressingType()));
            }
            if (!(launchSpecificationBlockDeviceMappingsList = (SdkInternalList)launchSpecification.getBlockDeviceMappings()).isEmpty() || !launchSpecificationBlockDeviceMappingsList.isAutoConstruct()) {
                int blockDeviceMappingsListIndex = 1;
                for (BlockDeviceMapping launchSpecificationBlockDeviceMappingsListValue : launchSpecificationBlockDeviceMappingsList) {
                    Object ebs;
                    if (launchSpecificationBlockDeviceMappingsListValue.getDeviceName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)launchSpecificationBlockDeviceMappingsListValue.getDeviceName()));
                    }
                    if (launchSpecificationBlockDeviceMappingsListValue.getVirtualName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)launchSpecificationBlockDeviceMappingsListValue.getVirtualName()));
                    }
                    if ((ebs = launchSpecificationBlockDeviceMappingsListValue.getEbs()) != null) {
                        if (((EbsBlockDevice)ebs).getDeleteOnTermination() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)((EbsBlockDevice)ebs).getDeleteOnTermination()));
                        }
                        if (((EbsBlockDevice)ebs).getIops() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)((EbsBlockDevice)ebs).getIops()));
                        }
                        if (((EbsBlockDevice)ebs).getSnapshotId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)((EbsBlockDevice)ebs).getSnapshotId()));
                        }
                        if (((EbsBlockDevice)ebs).getVolumeSize() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)((EbsBlockDevice)ebs).getVolumeSize()));
                        }
                        if (((EbsBlockDevice)ebs).getVolumeType() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)((EbsBlockDevice)ebs).getVolumeType()));
                        }
                        if (((EbsBlockDevice)ebs).getKmsKeyId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.KmsKeyId", StringUtils.fromString((String)((EbsBlockDevice)ebs).getKmsKeyId()));
                        }
                        if (((EbsBlockDevice)ebs).getThroughput() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Throughput", StringUtils.fromInteger((Integer)((EbsBlockDevice)ebs).getThroughput()));
                        }
                        if (((EbsBlockDevice)ebs).getOutpostArn() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.OutpostArn", StringUtils.fromString((String)((EbsBlockDevice)ebs).getOutpostArn()));
                        }
                        if (((EbsBlockDevice)ebs).getEncrypted() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)((EbsBlockDevice)ebs).getEncrypted()));
                        }
                    }
                    if (launchSpecificationBlockDeviceMappingsListValue.getNoDevice() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)launchSpecificationBlockDeviceMappingsListValue.getNoDevice()));
                    }
                    ++blockDeviceMappingsListIndex;
                }
            }
            if (launchSpecification.getEbsOptimized() != null) {
                request.addParameter("LaunchSpecification.EbsOptimized", StringUtils.fromBoolean((Boolean)launchSpecification.getEbsOptimized()));
            }
            if ((iamInstanceProfile = launchSpecification.getIamInstanceProfile()) != null) {
                if (iamInstanceProfile.getArn() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.getArn()));
                }
                if (iamInstanceProfile.getName() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.getName()));
                }
            }
            if (launchSpecification.getImageId() != null) {
                request.addParameter("LaunchSpecification.ImageId", StringUtils.fromString((String)launchSpecification.getImageId()));
            }
            if (launchSpecification.getInstanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString((String)launchSpecification.getInstanceType()));
            }
            if (launchSpecification.getKernelId() != null) {
                request.addParameter("LaunchSpecification.KernelId", StringUtils.fromString((String)launchSpecification.getKernelId()));
            }
            if (launchSpecification.getKeyName() != null) {
                request.addParameter("LaunchSpecification.KeyName", StringUtils.fromString((String)launchSpecification.getKeyName()));
            }
            if (!(launchSpecificationNetworkInterfacesList = (SdkInternalList)launchSpecification.getNetworkInterfaces()).isEmpty() || !launchSpecificationNetworkInterfacesList.isAutoConstruct()) {
                int networkInterfacesListIndex = 1;
                for (InstanceNetworkInterfaceSpecification launchSpecificationNetworkInterfacesListValue : launchSpecificationNetworkInterfacesList) {
                    SdkInternalList instanceNetworkInterfaceSpecificationIpv6PrefixesList;
                    SdkInternalList instanceNetworkInterfaceSpecificationIpv4PrefixesList;
                    SdkInternalList instanceNetworkInterfaceSpecificationPrivateIpAddressesList;
                    SdkInternalList instanceNetworkInterfaceSpecificationIpv6AddressesList;
                    Iterator instanceNetworkInterfaceSpecificationGroupsList;
                    if (launchSpecificationNetworkInterfacesListValue.getAssociatePublicIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)launchSpecificationNetworkInterfacesListValue.getAssociatePublicIpAddress()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.getDeleteOnTermination() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)launchSpecificationNetworkInterfacesListValue.getDeleteOnTermination()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.getDescription() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)launchSpecificationNetworkInterfacesListValue.getDescription()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.getDeviceIndex() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)launchSpecificationNetworkInterfacesListValue.getDeviceIndex()));
                    }
                    if (!(instanceNetworkInterfaceSpecificationGroupsList = (SdkInternalList)launchSpecificationNetworkInterfacesListValue.getGroups()).isEmpty() || !instanceNetworkInterfaceSpecificationGroupsList.isAutoConstruct()) {
                        int groupsListIndex = 1;
                        Iterator iterator = instanceNetworkInterfaceSpecificationGroupsList.iterator();
                        while (iterator.hasNext()) {
                            String instanceNetworkInterfaceSpecificationGroupsListValue = (String)iterator.next();
                            if (instanceNetworkInterfaceSpecificationGroupsListValue != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)instanceNetworkInterfaceSpecificationGroupsListValue));
                            }
                            ++groupsListIndex;
                        }
                    }
                    if (launchSpecificationNetworkInterfacesListValue.getIpv6AddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6AddressCount", StringUtils.fromInteger((Integer)launchSpecificationNetworkInterfacesListValue.getIpv6AddressCount()));
                    }
                    if (!(instanceNetworkInterfaceSpecificationIpv6AddressesList = (SdkInternalList)launchSpecificationNetworkInterfacesListValue.getIpv6Addresses()).isEmpty() || !instanceNetworkInterfaceSpecificationIpv6AddressesList.isAutoConstruct()) {
                        int ipv6AddressesListIndex = 1;
                        for (Object instanceNetworkInterfaceSpecificationIpv6AddressesListValue : instanceNetworkInterfaceSpecificationIpv6AddressesList) {
                            if (((InstanceIpv6Address)instanceNetworkInterfaceSpecificationIpv6AddressesListValue).getIpv6Address() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".Ipv6Address", StringUtils.fromString((String)((InstanceIpv6Address)instanceNetworkInterfaceSpecificationIpv6AddressesListValue).getIpv6Address()));
                            }
                            if (((InstanceIpv6Address)instanceNetworkInterfaceSpecificationIpv6AddressesListValue).getIsPrimaryIpv6() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6Addresses." + ipv6AddressesListIndex + ".IsPrimaryIpv6", StringUtils.fromBoolean((Boolean)((InstanceIpv6Address)instanceNetworkInterfaceSpecificationIpv6AddressesListValue).getIsPrimaryIpv6()));
                            }
                            ++ipv6AddressesListIndex;
                        }
                    }
                    if (launchSpecificationNetworkInterfacesListValue.getNetworkInterfaceId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)launchSpecificationNetworkInterfacesListValue.getNetworkInterfaceId()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.getPrivateIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)launchSpecificationNetworkInterfacesListValue.getPrivateIpAddress()));
                    }
                    if (!(instanceNetworkInterfaceSpecificationPrivateIpAddressesList = (SdkInternalList)launchSpecificationNetworkInterfacesListValue.getPrivateIpAddresses()).isEmpty() || !instanceNetworkInterfaceSpecificationPrivateIpAddressesList.isAutoConstruct()) {
                        Object instanceNetworkInterfaceSpecificationIpv6AddressesListValue;
                        int privateIpAddressesListIndex = 1;
                        instanceNetworkInterfaceSpecificationIpv6AddressesListValue = instanceNetworkInterfaceSpecificationPrivateIpAddressesList.iterator();
                        while (instanceNetworkInterfaceSpecificationIpv6AddressesListValue.hasNext()) {
                            PrivateIpAddressSpecification instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue = (PrivateIpAddressSpecification)instanceNetworkInterfaceSpecificationIpv6AddressesListValue.next();
                            if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrimary() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrimary()));
                            }
                            if (instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrivateIpAddress() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationPrivateIpAddressesListValue.getPrivateIpAddress()));
                            }
                            ++privateIpAddressesListIndex;
                        }
                    }
                    if (launchSpecificationNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)launchSpecificationNetworkInterfacesListValue.getSecondaryPrivateIpAddressCount()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.getSubnetId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)launchSpecificationNetworkInterfacesListValue.getSubnetId()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.getAssociateCarrierIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".AssociateCarrierIpAddress", StringUtils.fromBoolean((Boolean)launchSpecificationNetworkInterfacesListValue.getAssociateCarrierIpAddress()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.getInterfaceType() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".InterfaceType", StringUtils.fromString((String)launchSpecificationNetworkInterfacesListValue.getInterfaceType()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.getNetworkCardIndex() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".NetworkCardIndex", StringUtils.fromInteger((Integer)launchSpecificationNetworkInterfacesListValue.getNetworkCardIndex()));
                    }
                    if (!(instanceNetworkInterfaceSpecificationIpv4PrefixesList = (SdkInternalList)launchSpecificationNetworkInterfacesListValue.getIpv4Prefixes()).isEmpty() || !instanceNetworkInterfaceSpecificationIpv4PrefixesList.isAutoConstruct()) {
                        int ipv4PrefixesListIndex = 1;
                        for (Ipv4PrefixSpecificationRequest instanceNetworkInterfaceSpecificationIpv4PrefixesListValue : instanceNetworkInterfaceSpecificationIpv4PrefixesList) {
                            if (instanceNetworkInterfaceSpecificationIpv4PrefixesListValue.getIpv4Prefix() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv4Prefix." + ipv4PrefixesListIndex + ".Ipv4Prefix", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationIpv4PrefixesListValue.getIpv4Prefix()));
                            }
                            ++ipv4PrefixesListIndex;
                        }
                    }
                    if (launchSpecificationNetworkInterfacesListValue.getIpv4PrefixCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv4PrefixCount", StringUtils.fromInteger((Integer)launchSpecificationNetworkInterfacesListValue.getIpv4PrefixCount()));
                    }
                    if (!(instanceNetworkInterfaceSpecificationIpv6PrefixesList = (SdkInternalList)launchSpecificationNetworkInterfacesListValue.getIpv6Prefixes()).isEmpty() || !instanceNetworkInterfaceSpecificationIpv6PrefixesList.isAutoConstruct()) {
                        int ipv6PrefixesListIndex = 1;
                        for (Ipv6PrefixSpecificationRequest instanceNetworkInterfaceSpecificationIpv6PrefixesListValue : instanceNetworkInterfaceSpecificationIpv6PrefixesList) {
                            if (instanceNetworkInterfaceSpecificationIpv6PrefixesListValue.getIpv6Prefix() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6Prefix." + ipv6PrefixesListIndex + ".Ipv6Prefix", StringUtils.fromString((String)instanceNetworkInterfaceSpecificationIpv6PrefixesListValue.getIpv6Prefix()));
                            }
                            ++ipv6PrefixesListIndex;
                        }
                    }
                    if (launchSpecificationNetworkInterfacesListValue.getIpv6PrefixCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Ipv6PrefixCount", StringUtils.fromInteger((Integer)launchSpecificationNetworkInterfacesListValue.getIpv6PrefixCount()));
                    }
                    if (launchSpecificationNetworkInterfacesListValue.getPrimaryIpv6() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrimaryIpv6", StringUtils.fromBoolean((Boolean)launchSpecificationNetworkInterfacesListValue.getPrimaryIpv6()));
                    }
                    ++networkInterfacesListIndex;
                }
            }
            if ((placement = launchSpecification.getPlacement()) != null) {
                if (placement.getAvailabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString((String)placement.getAvailabilityZone()));
                }
                if (placement.getGroupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString((String)placement.getGroupName()));
                }
                if (placement.getTenancy() != null) {
                    request.addParameter("LaunchSpecification.Placement.Tenancy", StringUtils.fromString((String)placement.getTenancy()));
                }
            }
            if (launchSpecification.getRamdiskId() != null) {
                request.addParameter("LaunchSpecification.RamdiskId", StringUtils.fromString((String)launchSpecification.getRamdiskId()));
            }
            if (launchSpecification.getSubnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString((String)launchSpecification.getSubnetId()));
            }
            if (!(launchSpecificationAllSecurityGroupsList = (SdkInternalList)launchSpecification.getAllSecurityGroups()).isEmpty() || !launchSpecificationAllSecurityGroupsList.isAutoConstruct()) {
                int allSecurityGroupsListIndex = 1;
                for (Object launchSpecificationAllSecurityGroupsListValue : launchSpecificationAllSecurityGroupsList) {
                    if (((GroupIdentifier)launchSpecificationAllSecurityGroupsListValue).getGroupName() != null) {
                        request.addParameter("LaunchSpecification.GroupSet." + allSecurityGroupsListIndex + ".GroupName", StringUtils.fromString((String)((GroupIdentifier)launchSpecificationAllSecurityGroupsListValue).getGroupName()));
                    }
                    if (((GroupIdentifier)launchSpecificationAllSecurityGroupsListValue).getGroupId() != null) {
                        request.addParameter("LaunchSpecification.GroupSet." + allSecurityGroupsListIndex + ".GroupId", StringUtils.fromString((String)((GroupIdentifier)launchSpecificationAllSecurityGroupsListValue).getGroupId()));
                    }
                    ++allSecurityGroupsListIndex;
                }
            }
            if (launchSpecification.getMonitoringEnabled() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean((Boolean)launchSpecification.getMonitoringEnabled()));
            }
            if (!(launchSpecificationSecurityGroupsList = (SdkInternalList)launchSpecification.getSecurityGroups()).isEmpty() || !launchSpecificationSecurityGroupsList.isAutoConstruct()) {
                int securityGroupsListIndex = 1;
                for (String launchSpecificationSecurityGroupsListValue : launchSpecificationSecurityGroupsList) {
                    if (launchSpecificationSecurityGroupsListValue != null) {
                        request.addParameter("LaunchSpecification.SecurityGroup." + securityGroupsListIndex, StringUtils.fromString((String)launchSpecificationSecurityGroupsListValue));
                    }
                    ++securityGroupsListIndex;
                }
            }
        }
        if (requestSpotInstancesRequest.getSpotPrice() != null) {
            request.addParameter("SpotPrice", StringUtils.fromString((String)requestSpotInstancesRequest.getSpotPrice()));
        }
        if (requestSpotInstancesRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString((String)requestSpotInstancesRequest.getType()));
        }
        if (requestSpotInstancesRequest.getValidFrom() != null) {
            request.addParameter("ValidFrom", StringUtils.fromDate((Date)requestSpotInstancesRequest.getValidFrom()));
        }
        if (requestSpotInstancesRequest.getValidUntil() != null) {
            request.addParameter("ValidUntil", StringUtils.fromDate((Date)requestSpotInstancesRequest.getValidUntil()));
        }
        if (!(requestSpotInstancesRequestTagSpecificationsList = (SdkInternalList)requestSpotInstancesRequest.getTagSpecifications()).isEmpty() || !requestSpotInstancesRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification requestSpotInstancesRequestTagSpecificationsListValue : requestSpotInstancesRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (requestSpotInstancesRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)requestSpotInstancesRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)requestSpotInstancesRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (requestSpotInstancesRequest.getInstanceInterruptionBehavior() != null) {
            request.addParameter("InstanceInterruptionBehavior", StringUtils.fromString((String)requestSpotInstancesRequest.getInstanceInterruptionBehavior()));
        }
        return request;
    }
}

