/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.VerifiedAccessEndpointProtocol;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateVerifiedAccessEndpointLoadBalancerOptions
implements Serializable,
Cloneable {
    private String protocol;
    private Integer port;
    private String loadBalancerArn;
    private SdkInternalList<String> subnetIds;

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public CreateVerifiedAccessEndpointLoadBalancerOptions withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public CreateVerifiedAccessEndpointLoadBalancerOptions withProtocol(VerifiedAccessEndpointProtocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public CreateVerifiedAccessEndpointLoadBalancerOptions withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public void setLoadBalancerArn(String loadBalancerArn) {
        this.loadBalancerArn = loadBalancerArn;
    }

    public String getLoadBalancerArn() {
        return this.loadBalancerArn;
    }

    public CreateVerifiedAccessEndpointLoadBalancerOptions withLoadBalancerArn(String loadBalancerArn) {
        this.setLoadBalancerArn(loadBalancerArn);
        return this;
    }

    public List<String> getSubnetIds() {
        if (this.subnetIds == null) {
            this.subnetIds = new SdkInternalList();
        }
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        this.subnetIds = new SdkInternalList(subnetIds);
    }

    public CreateVerifiedAccessEndpointLoadBalancerOptions withSubnetIds(String ... subnetIds) {
        if (this.subnetIds == null) {
            this.setSubnetIds((Collection<String>)new SdkInternalList(subnetIds.length));
        }
        for (String ele : subnetIds) {
            this.subnetIds.add((Object)ele);
        }
        return this;
    }

    public CreateVerifiedAccessEndpointLoadBalancerOptions withSubnetIds(Collection<String> subnetIds) {
        this.setSubnetIds(subnetIds);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getLoadBalancerArn() != null) {
            sb.append("LoadBalancerArn: ").append(this.getLoadBalancerArn()).append(",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: ").append(this.getSubnetIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVerifiedAccessEndpointLoadBalancerOptions)) {
            return false;
        }
        CreateVerifiedAccessEndpointLoadBalancerOptions other = (CreateVerifiedAccessEndpointLoadBalancerOptions)obj;
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getLoadBalancerArn() == null ^ this.getLoadBalancerArn() == null) {
            return false;
        }
        if (other.getLoadBalancerArn() != null && !other.getLoadBalancerArn().equals(this.getLoadBalancerArn())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        return other.getSubnetIds() == null || other.getSubnetIds().equals(this.getSubnetIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancerArn() == null ? 0 : this.getLoadBalancerArn().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        return hashCode;
    }

    public CreateVerifiedAccessEndpointLoadBalancerOptions clone() {
        try {
            return (CreateVerifiedAccessEndpointLoadBalancerOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

