/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ArchitectureValues;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.BootModeValues;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TpmSupportValues;
import com.amazonaws.services.ec2.model.transform.RegisterImageRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class RegisterImageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<RegisterImageRequest> {
    private String imageLocation;
    private String architecture;
    private SdkInternalList<BlockDeviceMapping> blockDeviceMappings;
    private String description;
    private Boolean enaSupport;
    private String kernelId;
    private String name;
    private SdkInternalList<String> billingProducts;
    private String ramdiskId;
    private String rootDeviceName;
    private String sriovNetSupport;
    private String virtualizationType;
    private String bootMode;
    private String tpmSupport;
    private String uefiData;

    public RegisterImageRequest() {
    }

    public RegisterImageRequest(String imageLocation) {
        this.setImageLocation(imageLocation);
    }

    public void setImageLocation(String imageLocation) {
        this.imageLocation = imageLocation;
    }

    public String getImageLocation() {
        return this.imageLocation;
    }

    public RegisterImageRequest withImageLocation(String imageLocation) {
        this.setImageLocation(imageLocation);
        return this;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public RegisterImageRequest withArchitecture(String architecture) {
        this.setArchitecture(architecture);
        return this;
    }

    public void setArchitecture(ArchitectureValues architecture) {
        this.withArchitecture(architecture);
    }

    public RegisterImageRequest withArchitecture(ArchitectureValues architecture) {
        this.architecture = architecture.toString();
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new SdkInternalList();
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        this.blockDeviceMappings = new SdkInternalList(blockDeviceMappings);
    }

    public RegisterImageRequest withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.blockDeviceMappings == null) {
            this.setBlockDeviceMappings((Collection<BlockDeviceMapping>)new SdkInternalList(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping ele : blockDeviceMappings) {
            this.blockDeviceMappings.add((Object)ele);
        }
        return this;
    }

    public RegisterImageRequest withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        this.setBlockDeviceMappings(blockDeviceMappings);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public RegisterImageRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setEnaSupport(Boolean enaSupport) {
        this.enaSupport = enaSupport;
    }

    public Boolean getEnaSupport() {
        return this.enaSupport;
    }

    public RegisterImageRequest withEnaSupport(Boolean enaSupport) {
        this.setEnaSupport(enaSupport);
        return this;
    }

    public Boolean isEnaSupport() {
        return this.enaSupport;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public RegisterImageRequest withKernelId(String kernelId) {
        this.setKernelId(kernelId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public RegisterImageRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<String> getBillingProducts() {
        if (this.billingProducts == null) {
            this.billingProducts = new SdkInternalList();
        }
        return this.billingProducts;
    }

    public void setBillingProducts(Collection<String> billingProducts) {
        if (billingProducts == null) {
            this.billingProducts = null;
            return;
        }
        this.billingProducts = new SdkInternalList(billingProducts);
    }

    public RegisterImageRequest withBillingProducts(String ... billingProducts) {
        if (this.billingProducts == null) {
            this.setBillingProducts((Collection<String>)new SdkInternalList(billingProducts.length));
        }
        for (String ele : billingProducts) {
            this.billingProducts.add((Object)ele);
        }
        return this;
    }

    public RegisterImageRequest withBillingProducts(Collection<String> billingProducts) {
        this.setBillingProducts(billingProducts);
        return this;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public RegisterImageRequest withRamdiskId(String ramdiskId) {
        this.setRamdiskId(ramdiskId);
        return this;
    }

    public void setRootDeviceName(String rootDeviceName) {
        this.rootDeviceName = rootDeviceName;
    }

    public String getRootDeviceName() {
        return this.rootDeviceName;
    }

    public RegisterImageRequest withRootDeviceName(String rootDeviceName) {
        this.setRootDeviceName(rootDeviceName);
        return this;
    }

    public void setSriovNetSupport(String sriovNetSupport) {
        this.sriovNetSupport = sriovNetSupport;
    }

    public String getSriovNetSupport() {
        return this.sriovNetSupport;
    }

    public RegisterImageRequest withSriovNetSupport(String sriovNetSupport) {
        this.setSriovNetSupport(sriovNetSupport);
        return this;
    }

    public void setVirtualizationType(String virtualizationType) {
        this.virtualizationType = virtualizationType;
    }

    public String getVirtualizationType() {
        return this.virtualizationType;
    }

    public RegisterImageRequest withVirtualizationType(String virtualizationType) {
        this.setVirtualizationType(virtualizationType);
        return this;
    }

    public void setBootMode(String bootMode) {
        this.bootMode = bootMode;
    }

    public String getBootMode() {
        return this.bootMode;
    }

    public RegisterImageRequest withBootMode(String bootMode) {
        this.setBootMode(bootMode);
        return this;
    }

    public void setBootMode(BootModeValues bootMode) {
        this.withBootMode(bootMode);
    }

    public RegisterImageRequest withBootMode(BootModeValues bootMode) {
        this.bootMode = bootMode.toString();
        return this;
    }

    public void setTpmSupport(String tpmSupport) {
        this.tpmSupport = tpmSupport;
    }

    public String getTpmSupport() {
        return this.tpmSupport;
    }

    public RegisterImageRequest withTpmSupport(String tpmSupport) {
        this.setTpmSupport(tpmSupport);
        return this;
    }

    public void setTpmSupport(TpmSupportValues tpmSupport) {
        this.withTpmSupport(tpmSupport);
    }

    public RegisterImageRequest withTpmSupport(TpmSupportValues tpmSupport) {
        this.tpmSupport = tpmSupport.toString();
        return this;
    }

    public void setUefiData(String uefiData) {
        this.uefiData = uefiData;
    }

    public String getUefiData() {
        return this.uefiData;
    }

    public RegisterImageRequest withUefiData(String uefiData) {
        this.setUefiData(uefiData);
        return this;
    }

    @Override
    public Request<RegisterImageRequest> getDryRunRequest() {
        Request<RegisterImageRequest> request = new RegisterImageRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageLocation() != null) {
            sb.append("ImageLocation: ").append(this.getImageLocation()).append(",");
        }
        if (this.getArchitecture() != null) {
            sb.append("Architecture: ").append(this.getArchitecture()).append(",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(this.getBlockDeviceMappings()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEnaSupport() != null) {
            sb.append("EnaSupport: ").append(this.getEnaSupport()).append(",");
        }
        if (this.getKernelId() != null) {
            sb.append("KernelId: ").append(this.getKernelId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getBillingProducts() != null) {
            sb.append("BillingProducts: ").append(this.getBillingProducts()).append(",");
        }
        if (this.getRamdiskId() != null) {
            sb.append("RamdiskId: ").append(this.getRamdiskId()).append(",");
        }
        if (this.getRootDeviceName() != null) {
            sb.append("RootDeviceName: ").append(this.getRootDeviceName()).append(",");
        }
        if (this.getSriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(this.getSriovNetSupport()).append(",");
        }
        if (this.getVirtualizationType() != null) {
            sb.append("VirtualizationType: ").append(this.getVirtualizationType()).append(",");
        }
        if (this.getBootMode() != null) {
            sb.append("BootMode: ").append(this.getBootMode()).append(",");
        }
        if (this.getTpmSupport() != null) {
            sb.append("TpmSupport: ").append(this.getTpmSupport()).append(",");
        }
        if (this.getUefiData() != null) {
            sb.append("UefiData: ").append(this.getUefiData());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterImageRequest)) {
            return false;
        }
        RegisterImageRequest other = (RegisterImageRequest)obj;
        if (other.getImageLocation() == null ^ this.getImageLocation() == null) {
            return false;
        }
        if (other.getImageLocation() != null && !other.getImageLocation().equals(this.getImageLocation())) {
            return false;
        }
        if (other.getArchitecture() == null ^ this.getArchitecture() == null) {
            return false;
        }
        if (other.getArchitecture() != null && !other.getArchitecture().equals(this.getArchitecture())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEnaSupport() == null ^ this.getEnaSupport() == null) {
            return false;
        }
        if (other.getEnaSupport() != null && !other.getEnaSupport().equals(this.getEnaSupport())) {
            return false;
        }
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getBillingProducts() == null ^ this.getBillingProducts() == null) {
            return false;
        }
        if (other.getBillingProducts() != null && !other.getBillingProducts().equals(this.getBillingProducts())) {
            return false;
        }
        if (other.getRamdiskId() == null ^ this.getRamdiskId() == null) {
            return false;
        }
        if (other.getRamdiskId() != null && !other.getRamdiskId().equals(this.getRamdiskId())) {
            return false;
        }
        if (other.getRootDeviceName() == null ^ this.getRootDeviceName() == null) {
            return false;
        }
        if (other.getRootDeviceName() != null && !other.getRootDeviceName().equals(this.getRootDeviceName())) {
            return false;
        }
        if (other.getSriovNetSupport() == null ^ this.getSriovNetSupport() == null) {
            return false;
        }
        if (other.getSriovNetSupport() != null && !other.getSriovNetSupport().equals(this.getSriovNetSupport())) {
            return false;
        }
        if (other.getVirtualizationType() == null ^ this.getVirtualizationType() == null) {
            return false;
        }
        if (other.getVirtualizationType() != null && !other.getVirtualizationType().equals(this.getVirtualizationType())) {
            return false;
        }
        if (other.getBootMode() == null ^ this.getBootMode() == null) {
            return false;
        }
        if (other.getBootMode() != null && !other.getBootMode().equals(this.getBootMode())) {
            return false;
        }
        if (other.getTpmSupport() == null ^ this.getTpmSupport() == null) {
            return false;
        }
        if (other.getTpmSupport() != null && !other.getTpmSupport().equals(this.getTpmSupport())) {
            return false;
        }
        if (other.getUefiData() == null ^ this.getUefiData() == null) {
            return false;
        }
        return other.getUefiData() == null || other.getUefiData().equals(this.getUefiData());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageLocation() == null ? 0 : this.getImageLocation().hashCode());
        hashCode = 31 * hashCode + (this.getArchitecture() == null ? 0 : this.getArchitecture().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEnaSupport() == null ? 0 : this.getEnaSupport().hashCode());
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getBillingProducts() == null ? 0 : this.getBillingProducts().hashCode());
        hashCode = 31 * hashCode + (this.getRamdiskId() == null ? 0 : this.getRamdiskId().hashCode());
        hashCode = 31 * hashCode + (this.getRootDeviceName() == null ? 0 : this.getRootDeviceName().hashCode());
        hashCode = 31 * hashCode + (this.getSriovNetSupport() == null ? 0 : this.getSriovNetSupport().hashCode());
        hashCode = 31 * hashCode + (this.getVirtualizationType() == null ? 0 : this.getVirtualizationType().hashCode());
        hashCode = 31 * hashCode + (this.getBootMode() == null ? 0 : this.getBootMode().hashCode());
        hashCode = 31 * hashCode + (this.getTpmSupport() == null ? 0 : this.getTpmSupport().hashCode());
        hashCode = 31 * hashCode + (this.getUefiData() == null ? 0 : this.getUefiData().hashCode());
        return hashCode;
    }

    public RegisterImageRequest clone() {
        return (RegisterImageRequest)super.clone();
    }
}

