/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class SecurityGroup
implements Serializable,
Cloneable {
    private String ownerId;
    private String groupName;
    private String groupId;
    private String description;
    private SdkInternalList<IpPermission> ipPermissions;
    private SdkInternalList<IpPermission> ipPermissionsEgress;
    private String vpcId;
    private SdkInternalList<Tag> tags;

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public SecurityGroup withOwnerId(String ownerId) {
        this.setOwnerId(ownerId);
        return this;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public SecurityGroup withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public SecurityGroup withGroupId(String groupId) {
        this.setGroupId(groupId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public SecurityGroup withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<IpPermission> getIpPermissions() {
        if (this.ipPermissions == null) {
            this.ipPermissions = new SdkInternalList();
        }
        return this.ipPermissions;
    }

    public void setIpPermissions(Collection<IpPermission> ipPermissions) {
        if (ipPermissions == null) {
            this.ipPermissions = null;
            return;
        }
        this.ipPermissions = new SdkInternalList(ipPermissions);
    }

    public SecurityGroup withIpPermissions(IpPermission ... ipPermissions) {
        if (this.ipPermissions == null) {
            this.setIpPermissions((Collection<IpPermission>)new SdkInternalList(ipPermissions.length));
        }
        for (IpPermission ele : ipPermissions) {
            this.ipPermissions.add((Object)ele);
        }
        return this;
    }

    public SecurityGroup withIpPermissions(Collection<IpPermission> ipPermissions) {
        this.setIpPermissions(ipPermissions);
        return this;
    }

    public List<IpPermission> getIpPermissionsEgress() {
        if (this.ipPermissionsEgress == null) {
            this.ipPermissionsEgress = new SdkInternalList();
        }
        return this.ipPermissionsEgress;
    }

    public void setIpPermissionsEgress(Collection<IpPermission> ipPermissionsEgress) {
        if (ipPermissionsEgress == null) {
            this.ipPermissionsEgress = null;
            return;
        }
        this.ipPermissionsEgress = new SdkInternalList(ipPermissionsEgress);
    }

    public SecurityGroup withIpPermissionsEgress(IpPermission ... ipPermissionsEgress) {
        if (this.ipPermissionsEgress == null) {
            this.setIpPermissionsEgress((Collection<IpPermission>)new SdkInternalList(ipPermissionsEgress.length));
        }
        for (IpPermission ele : ipPermissionsEgress) {
            this.ipPermissionsEgress.add((Object)ele);
        }
        return this;
    }

    public SecurityGroup withIpPermissionsEgress(Collection<IpPermission> ipPermissionsEgress) {
        this.setIpPermissionsEgress(ipPermissionsEgress);
        return this;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public SecurityGroup withVpcId(String vpcId) {
        this.setVpcId(vpcId);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public SecurityGroup withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public SecurityGroup withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: " + this.getOwnerId() + ",");
        }
        if (this.getGroupName() != null) {
            sb.append("GroupName: " + this.getGroupName() + ",");
        }
        if (this.getGroupId() != null) {
            sb.append("GroupId: " + this.getGroupId() + ",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: " + this.getDescription() + ",");
        }
        if (this.getIpPermissions() != null) {
            sb.append("IpPermissions: " + this.getIpPermissions() + ",");
        }
        if (this.getIpPermissionsEgress() != null) {
            sb.append("IpPermissionsEgress: " + this.getIpPermissionsEgress() + ",");
        }
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityGroup)) {
            return false;
        }
        SecurityGroup other = (SecurityGroup)obj;
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getGroupId() == null ^ this.getGroupId() == null) {
            return false;
        }
        if (other.getGroupId() != null && !other.getGroupId().equals(this.getGroupId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getIpPermissions() == null ^ this.getIpPermissions() == null) {
            return false;
        }
        if (other.getIpPermissions() != null && !other.getIpPermissions().equals(this.getIpPermissions())) {
            return false;
        }
        if (other.getIpPermissionsEgress() == null ^ this.getIpPermissionsEgress() == null) {
            return false;
        }
        if (other.getIpPermissionsEgress() != null && !other.getIpPermissionsEgress().equals(this.getIpPermissionsEgress())) {
            return false;
        }
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getGroupId() == null ? 0 : this.getGroupId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getIpPermissions() == null ? 0 : this.getIpPermissions().hashCode());
        hashCode = 31 * hashCode + (this.getIpPermissionsEgress() == null ? 0 : this.getIpPermissionsEgress().hashCode());
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public SecurityGroup clone() {
        try {
            return (SecurityGroup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

