/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.datamodeling;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMappingException;
import com.amazonaws.services.dynamodbv2.datamodeling.S3Link;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import com.amazonaws.util.DateUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

@SdkInternalApi
final class StandardTypeConverters {
    StandardTypeConverters() {
    }

    private static final class StringToEnum<T extends Enum<T>>
    extends ConvertTo<String, T> {
        private final Class<T> targetType;

        private StringToEnum(Class<T> targetType) {
            this.targetType = targetType;
        }

        @Override
        public final T convertTo(String o) {
            return Enum.valueOf(this.targetType, o);
        }
    }

    private static final class ConvertToMap<T>
    extends LinkedHashMap<Class<?>, ConvertTo<?, T>> {
        private final Class<?> primitiveType;
        private final Class<T> type;

        private ConvertToMap(Class<T> type, Class<?> primitiveType) {
            this.primitiveType = primitiveType;
            this.type = type;
        }

        private final <S> ConvertToMap<T> with(Class<S> key, ConvertTo<S, T> convertTo) {
            if (super.put(key, convertTo) != null) {
                throw new IllegalStateException("duplicate conversion for type " + key);
            }
            return this;
        }

        static /* synthetic */ ConvertToMap access$100(ConvertToMap x0, Class x1, ConvertTo x2) {
            return x0.with(x1, x2);
        }
    }

    static enum Scalar {
        BIG_DECIMAL(ScalarAttributeType.N, ConvertToMap.access$100(new ConvertToMap<T>(BigDecimal.class, null), String.class, new ConvertTo<String, BigDecimal>(){

            @Override
            public final BigDecimal convertTo(String o) {
                return new BigDecimal(o);
            }
        })),
        BIG_INTEGER(ScalarAttributeType.N, ConvertToMap.access$100(new ConvertToMap<T>(BigInteger.class, null), String.class, new ConvertTo<String, BigInteger>(){

            @Override
            public final BigInteger convertTo(String o) {
                return new BigInteger(o);
            }
        })),
        BOOLEAN(ScalarAttributeType.N, ConvertToMap.access$100(new ConvertToMap<T>(Boolean.class, Boolean.TYPE), String.class, new ConvertTo<String, Boolean>(){

            @Override
            public final Boolean convertTo(String o) {
                return "0".equals(o) ? Boolean.FALSE : ("1".equals(o) ? Boolean.TRUE : Boolean.valueOf(o));
            }
        })),
        BYTE(ScalarAttributeType.N, ConvertToMap.access$100(new ConvertToMap<T>(Byte.class, Byte.TYPE), String.class, new ConvertTo<String, Byte>(){

            @Override
            public final Byte convertTo(String o) {
                return Byte.valueOf(o);
            }
        })),
        BYTE_ARRAY(ScalarAttributeType.B, ConvertToMap.access$100(new ConvertToMap<T>(byte[].class, null), ByteBuffer.class, new ConvertTo<ByteBuffer, byte[]>(){

            @Override
            public final byte[] convertTo(ByteBuffer o) {
                if (o.hasArray()) {
                    return o.array();
                }
                byte[] array = new byte[o.remaining()];
                o.get(array);
                return array;
            }
        })),
        BYTE_BUFFER(ScalarAttributeType.B, ConvertToMap.access$100(new ConvertToMap<T>(ByteBuffer.class, null), byte[].class, new ConvertTo<byte[], ByteBuffer>(){

            @Override
            public final ByteBuffer convertTo(byte[] o) {
                return ByteBuffer.wrap(o);
            }
        })),
        CALENDAR(ScalarAttributeType.S, ConvertToMap.access$100(ConvertToMap.access$100(new ConvertToMap<T>(Calendar.class, null), Date.class, new ConvertTo<Date, Calendar>(){

            @Override
            public final Calendar convertTo(Date o) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(o);
                return calendar;
            }
        }), String.class, new ConvertTo<String, Calendar>(){

            @Override
            public final Calendar convertTo(String o) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(DateUtils.parseISO8601Date((String)o));
                return calendar;
            }
        })),
        CHARACTER(null, ConvertToMap.access$100(new ConvertToMap<T>(Character.class, Character.TYPE), String.class, new ConvertTo<String, Character>(){

            @Override
            public final Character convertTo(String o) {
                if (o.length() != 1) {
                    throw new DynamoDBMappingException("expected single character string");
                }
                return Character.valueOf(o.charAt(0));
            }
        })),
        DATE(ScalarAttributeType.S, ConvertToMap.access$100(ConvertToMap.access$100(ConvertToMap.access$100(new ConvertToMap<T>(Date.class, null), Calendar.class, new ConvertTo<Calendar, Date>(){

            @Override
            public final Date convertTo(Calendar o) {
                return o.getTime();
            }
        }), Long.class, new ConvertTo<Long, Date>(){

            @Override
            public final Date convertTo(Long o) {
                return new Date(o);
            }
        }), String.class, new ConvertTo<String, Date>(){

            @Override
            public final Date convertTo(String o) {
                return DateUtils.parseISO8601Date((String)o);
            }
        })),
        DOUBLE(ScalarAttributeType.N, ConvertToMap.access$100(new ConvertToMap<T>(Double.class, Double.TYPE), String.class, new ConvertTo<String, Double>(){

            @Override
            public final Double convertTo(String o) {
                return Double.valueOf(o);
            }
        })),
        ENUM(null, new ConvertToMap<T>(Enum.class, null)),
        FLOAT(ScalarAttributeType.N, ConvertToMap.access$100(new ConvertToMap<T>(Float.class, Float.TYPE), String.class, new ConvertTo<String, Float>(){

            @Override
            public final Float convertTo(String o) {
                return Float.valueOf(o);
            }
        })),
        INTEGER(ScalarAttributeType.N, ConvertToMap.access$100(new ConvertToMap<T>(Integer.class, Integer.TYPE), String.class, new ConvertTo<String, Integer>(){

            @Override
            public final Integer convertTo(String o) {
                return Integer.valueOf(o);
            }
        })),
        LIST(null, new ConvertToMap<T>(List.class, null)),
        LONG(ScalarAttributeType.N, ConvertToMap.access$100(ConvertToMap.access$100(new ConvertToMap<T>(Long.class, Long.TYPE), Date.class, new ConvertTo<Date, Long>(){

            @Override
            public final Long convertTo(Date o) {
                return o.getTime();
            }
        }), String.class, new ConvertTo<String, Long>(){

            @Override
            public final Long convertTo(String o) {
                return Long.valueOf(o);
            }
        })),
        MAP(null, new ConvertToMap<T>(Map.class, null)),
        S3_LINK(ScalarAttributeType.S, new ConvertToMap<T>(S3Link.class, null)),
        SET(null, new ConvertToMap<T>(Set.class, null)),
        SHORT(ScalarAttributeType.N, ConvertToMap.access$100(new ConvertToMap<T>(Short.class, Short.TYPE), String.class, new ConvertTo<String, Short>(){

            @Override
            public final Short convertTo(String o) {
                return Short.valueOf(o);
            }
        })),
        STRING(ScalarAttributeType.S, ConvertToMap.access$100(ConvertToMap.access$100(ConvertToMap.access$100(ConvertToMap.access$100(ConvertToMap.access$100(ConvertToMap.access$100(new ConvertToMap<T>(String.class, null), Boolean.class, new ConvertTo<Boolean, String>(){

            @Override
            public final String convertTo(Boolean o) {
                return Boolean.TRUE.equals(o) ? "1" : "0";
            }
        }), Calendar.class, new ConvertTo<Calendar, String>(){

            @Override
            public final String convertTo(Calendar o) {
                return DateUtils.formatISO8601Date((Date)o.getTime());
            }
        }), Date.class, new ConvertTo<Date, String>(){

            @Override
            public final String convertTo(Date o) {
                return DateUtils.formatISO8601Date((Date)o);
            }
        }), Enum.class, new ConvertTo<Enum, String>(){

            @Override
            public final String convertTo(Enum o) {
                return o.name();
            }
        }), S3Link.class, new ConvertTo<S3Link, String>(){

            @Override
            public final String convertTo(S3Link o) {
                return o.getBucketName() == null || o.getKey() == null ? null : o.toJson();
            }
        }), Object.class, new ConvertTo<Object, String>(){

            @Override
            public final String convertTo(Object o) {
                return o.toString();
            }
        })),
        UUID(ScalarAttributeType.S, ConvertToMap.access$100(new ConvertToMap<T>(UUID.class, null), String.class, new ConvertTo<String, UUID>(){

            @Override
            public final UUID convertTo(String o) {
                return java.util.UUID.fromString(o);
            }
        })),
        DEFAULT(null, ConvertToMap.access$100(new ConvertToMap<T>(Object.class, null), Object.class, ConvertTo.ANY));

        private final ScalarAttributeType scalarAttributeType;
        private final ConvertToMap<?> map;

        private Scalar(ScalarAttributeType scalarAttributeType, ConvertToMap<?> map) {
            this.scalarAttributeType = scalarAttributeType;
            this.map = map;
        }

        public final ScalarAttributeType scalarAttributeType() {
            return this.scalarAttributeType;
        }

        public final <S, T> ConvertTo<S, T> to(Scalar scalar) {
            for (Class key : scalar.map.keySet()) {
                if (!key.isAssignableFrom(((ConvertToMap)this.map).type)) continue;
                return (ConvertTo)scalar.map.get(key);
            }
            if (this == scalar) {
                return ConvertTo.ANY;
            }
            throw new DynamoDBMappingException("unsupported " + (Object)((Object)this) + " to " + (Object)((Object)scalar));
        }

        public final <S, T> ConvertTo<S, T> to(Class<T> targetType, boolean primitive) {
            if (this == STRING && targetType.isEnum()) {
                return new StringToEnum(targetType);
            }
            return this.to(Scalar.of(targetType, primitive));
        }

        public static final Scalar of(Class<?> targetType, boolean primitive) {
            block2: {
                block3: {
                    if (targetType == null) break block2;
                    if (targetType.isPrimitive()) break block3;
                    for (Scalar scalar : Scalar.values()) {
                        if (!((ConvertToMap)scalar.map).type.isAssignableFrom(targetType)) continue;
                        return scalar;
                    }
                    break block2;
                }
                if (!primitive) break block2;
                for (Scalar scalar : Scalar.values()) {
                    if (((ConvertToMap)scalar.map).primitiveType == null || !((ConvertToMap)scalar.map).primitiveType.isAssignableFrom(targetType)) continue;
                    return scalar;
                }
            }
            return DEFAULT;
        }
    }

    static abstract class ConvertTo<S, T> {
        static final ConvertTo<?, ?> ANY = new ConvertTo<Object, Object>(){

            @Override
            public final Object convertTo(Object o) {
                return o;
            }
        };

        ConvertTo() {
        }

        public abstract T convertTo(S var1);
    }
}

