/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.drs.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.drs.model.StagingArea;

@SdkInternalApi
public class StagingAreaMarshaller {
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("errorMessage").build();
    private static final MarshallingInfo<String> STAGINGACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stagingAccountID").build();
    private static final MarshallingInfo<String> STAGINGSOURCESERVERARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("stagingSourceServerArn").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("status").build();
    private static final StagingAreaMarshaller instance = new StagingAreaMarshaller();

    public static StagingAreaMarshaller getInstance() {
        return instance;
    }

    public void marshall(StagingArea stagingArea, ProtocolMarshaller protocolMarshaller) {
        if (stagingArea == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)stagingArea.getErrorMessage(), ERRORMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)stagingArea.getStagingAccountID(), STAGINGACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)stagingArea.getStagingSourceServerArn(), STAGINGSOURCESERVERARN_BINDING);
            protocolMarshaller.marshall((Object)stagingArea.getStatus(), STATUS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

