/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.databasemigrationservice.model.Replication;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeReplicationsResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private String marker;
    private List<Replication> replications;

    public void setMarker(String marker) {
        this.marker = marker;
    }

    public String getMarker() {
        return this.marker;
    }

    public DescribeReplicationsResult withMarker(String marker) {
        this.setMarker(marker);
        return this;
    }

    public List<Replication> getReplications() {
        return this.replications;
    }

    public void setReplications(Collection<Replication> replications) {
        if (replications == null) {
            this.replications = null;
            return;
        }
        this.replications = new ArrayList<Replication>(replications);
    }

    public DescribeReplicationsResult withReplications(Replication ... replications) {
        if (this.replications == null) {
            this.setReplications(new ArrayList<Replication>(replications.length));
        }
        for (Replication ele : replications) {
            this.replications.add(ele);
        }
        return this;
    }

    public DescribeReplicationsResult withReplications(Collection<Replication> replications) {
        this.setReplications(replications);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMarker() != null) {
            sb.append("Marker: ").append(this.getMarker()).append(",");
        }
        if (this.getReplications() != null) {
            sb.append("Replications: ").append(this.getReplications());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReplicationsResult)) {
            return false;
        }
        DescribeReplicationsResult other = (DescribeReplicationsResult)obj;
        if (other.getMarker() == null ^ this.getMarker() == null) {
            return false;
        }
        if (other.getMarker() != null && !other.getMarker().equals(this.getMarker())) {
            return false;
        }
        if (other.getReplications() == null ^ this.getReplications() == null) {
            return false;
        }
        return other.getReplications() == null || other.getReplications().equals(this.getReplications());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMarker() == null ? 0 : this.getMarker().hashCode());
        hashCode = 31 * hashCode + (this.getReplications() == null ? 0 : this.getReplications().hashCode());
        return hashCode;
    }

    public DescribeReplicationsResult clone() {
        try {
            return (DescribeReplicationsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

