/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.databasemigrationservice.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.databasemigrationservice.model.KafkaSettings;

@SdkInternalApi
public class KafkaSettingsMarshaller {
    private static final MarshallingInfo<String> BROKER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Broker").build();
    private static final MarshallingInfo<String> TOPIC_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Topic").build();
    private static final MarshallingInfo<String> MESSAGEFORMAT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageFormat").build();
    private static final MarshallingInfo<Boolean> INCLUDETRANSACTIONDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludeTransactionDetails").build();
    private static final MarshallingInfo<Boolean> INCLUDEPARTITIONVALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludePartitionValue").build();
    private static final MarshallingInfo<Boolean> PARTITIONINCLUDESCHEMATABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PartitionIncludeSchemaTable").build();
    private static final MarshallingInfo<Boolean> INCLUDETABLEALTEROPERATIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludeTableAlterOperations").build();
    private static final MarshallingInfo<Boolean> INCLUDECONTROLDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludeControlDetails").build();
    private static final MarshallingInfo<Integer> MESSAGEMAXBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MessageMaxBytes").build();
    private static final MarshallingInfo<Boolean> INCLUDENULLANDEMPTY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IncludeNullAndEmpty").build();
    private static final MarshallingInfo<String> SECURITYPROTOCOL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SecurityProtocol").build();
    private static final MarshallingInfo<String> SSLCLIENTCERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SslClientCertificateArn").build();
    private static final MarshallingInfo<String> SSLCLIENTKEYARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SslClientKeyArn").build();
    private static final MarshallingInfo<String> SSLCLIENTKEYPASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SslClientKeyPassword").build();
    private static final MarshallingInfo<String> SSLCACERTIFICATEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SslCaCertificateArn").build();
    private static final MarshallingInfo<String> SASLUSERNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SaslUsername").build();
    private static final MarshallingInfo<String> SASLPASSWORD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SaslPassword").build();
    private static final KafkaSettingsMarshaller instance = new KafkaSettingsMarshaller();

    public static KafkaSettingsMarshaller getInstance() {
        return instance;
    }

    public void marshall(KafkaSettings kafkaSettings, ProtocolMarshaller protocolMarshaller) {
        if (kafkaSettings == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)kafkaSettings.getBroker(), BROKER_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getTopic(), TOPIC_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getMessageFormat(), MESSAGEFORMAT_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getIncludeTransactionDetails(), INCLUDETRANSACTIONDETAILS_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getIncludePartitionValue(), INCLUDEPARTITIONVALUE_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getPartitionIncludeSchemaTable(), PARTITIONINCLUDESCHEMATABLE_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getIncludeTableAlterOperations(), INCLUDETABLEALTEROPERATIONS_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getIncludeControlDetails(), INCLUDECONTROLDETAILS_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getMessageMaxBytes(), MESSAGEMAXBYTES_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getIncludeNullAndEmpty(), INCLUDENULLANDEMPTY_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getSecurityProtocol(), SECURITYPROTOCOL_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getSslClientCertificateArn(), SSLCLIENTCERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getSslClientKeyArn(), SSLCLIENTKEYARN_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getSslClientKeyPassword(), SSLCLIENTKEYPASSWORD_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getSslCaCertificateArn(), SSLCACERTIFICATEARN_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getSaslUsername(), SASLUSERNAME_BINDING);
            protocolMarshaller.marshall((Object)kafkaSettings.getSaslPassword(), SASLPASSWORD_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

