/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.directory.model.RadiusSettings;
import com.amazonaws.util.json.JSONWriter;

public class RadiusSettingsJsonMarshaller {
    private static RadiusSettingsJsonMarshaller instance;

    public void marshall(RadiusSettings radiusSettings, JSONWriter jsonWriter) {
        if (radiusSettings == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            SdkInternalList radiusServersList = (SdkInternalList)radiusSettings.getRadiusServers();
            if (!radiusServersList.isEmpty() || !radiusServersList.isAutoConstruct()) {
                jsonWriter.key("RadiusServers");
                jsonWriter.array();
                for (String radiusServersListValue : radiusServersList) {
                    if (radiusServersListValue == null) continue;
                    jsonWriter.value((Object)radiusServersListValue);
                }
                jsonWriter.endArray();
            }
            if (radiusSettings.getRadiusPort() != null) {
                jsonWriter.key("RadiusPort").value((Object)radiusSettings.getRadiusPort());
            }
            if (radiusSettings.getRadiusTimeout() != null) {
                jsonWriter.key("RadiusTimeout").value((Object)radiusSettings.getRadiusTimeout());
            }
            if (radiusSettings.getRadiusRetries() != null) {
                jsonWriter.key("RadiusRetries").value((Object)radiusSettings.getRadiusRetries());
            }
            if (radiusSettings.getSharedSecret() != null) {
                jsonWriter.key("SharedSecret").value((Object)radiusSettings.getSharedSecret());
            }
            if (radiusSettings.getAuthenticationProtocol() != null) {
                jsonWriter.key("AuthenticationProtocol").value((Object)radiusSettings.getAuthenticationProtocol());
            }
            if (radiusSettings.getDisplayLabel() != null) {
                jsonWriter.key("DisplayLabel").value((Object)radiusSettings.getDisplayLabel());
            }
            if (radiusSettings.getUseSameUsername() != null) {
                jsonWriter.key("UseSameUsername").value((Object)radiusSettings.getUseSameUsername());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static RadiusSettingsJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new RadiusSettingsJsonMarshaller();
        }
        return instance;
    }
}

