/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directconnect.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.directconnect.model.Loa;
import java.nio.ByteBuffer;

@SdkInternalApi
public class LoaMarshaller {
    private static final MarshallingInfo<ByteBuffer> LOACONTENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BYTE_BUFFER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loaContent").build();
    private static final MarshallingInfo<String> LOACONTENTTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("loaContentType").build();
    private static final LoaMarshaller instance = new LoaMarshaller();

    public static LoaMarshaller getInstance() {
        return instance;
    }

    public void marshall(Loa loa, ProtocolMarshaller protocolMarshaller) {
        if (loa == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)loa.getLoaContent(), LOACONTENT_BINDING);
            protocolMarshaller.marshall((Object)loa.getLoaContentType(), LOACONTENTTYPE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

