/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.detective.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.detective.model.MemberDetail;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class MemberDetailMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").build();
    private static final MarshallingInfo<String> EMAILADDRESS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EmailAddress").build();
    private static final MarshallingInfo<String> GRAPHARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("GraphArn").build();
    private static final MarshallingInfo<String> MASTERID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MasterId").build();
    private static final MarshallingInfo<String> ADMINISTRATORID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AdministratorId").build();
    private static final MarshallingInfo<String> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<String> DISABLEDREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DisabledReason").build();
    private static final MarshallingInfo<Date> INVITEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvitedTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Date> UPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdatedTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Long> VOLUMEUSAGEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeUsageInBytes").build();
    private static final MarshallingInfo<Date> VOLUMEUSAGEUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeUsageUpdatedTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<Double> PERCENTOFGRAPHUTILIZATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PercentOfGraphUtilization").build();
    private static final MarshallingInfo<Date> PERCENTOFGRAPHUTILIZATIONUPDATEDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PercentOfGraphUtilizationUpdatedTime").timestampFormat("iso8601").build();
    private static final MarshallingInfo<String> INVITATIONTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InvitationType").build();
    private static final MarshallingInfo<Map> VOLUMEUSAGEBYDATASOURCEPACKAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VolumeUsageByDatasourcePackage").build();
    private static final MarshallingInfo<Map> DATASOURCEPACKAGEINGESTSTATES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatasourcePackageIngestStates").build();
    private static final MemberDetailMarshaller instance = new MemberDetailMarshaller();

    public static MemberDetailMarshaller getInstance() {
        return instance;
    }

    public void marshall(MemberDetail memberDetail, ProtocolMarshaller protocolMarshaller) {
        if (memberDetail == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)memberDetail.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)memberDetail.getEmailAddress(), EMAILADDRESS_BINDING);
            protocolMarshaller.marshall((Object)memberDetail.getGraphArn(), GRAPHARN_BINDING);
            protocolMarshaller.marshall((Object)memberDetail.getMasterId(), MASTERID_BINDING);
            protocolMarshaller.marshall((Object)memberDetail.getAdministratorId(), ADMINISTRATORID_BINDING);
            protocolMarshaller.marshall((Object)memberDetail.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)memberDetail.getDisabledReason(), DISABLEDREASON_BINDING);
            protocolMarshaller.marshall((Object)memberDetail.getInvitedTime(), INVITEDTIME_BINDING);
            protocolMarshaller.marshall((Object)memberDetail.getUpdatedTime(), UPDATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)memberDetail.getVolumeUsageInBytes(), VOLUMEUSAGEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)memberDetail.getVolumeUsageUpdatedTime(), VOLUMEUSAGEUPDATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)memberDetail.getPercentOfGraphUtilization(), PERCENTOFGRAPHUTILIZATION_BINDING);
            protocolMarshaller.marshall((Object)memberDetail.getPercentOfGraphUtilizationUpdatedTime(), PERCENTOFGRAPHUTILIZATIONUPDATEDTIME_BINDING);
            protocolMarshaller.marshall((Object)memberDetail.getInvitationType(), INVITATIONTYPE_BINDING);
            protocolMarshaller.marshall(memberDetail.getVolumeUsageByDatasourcePackage(), VOLUMEUSAGEBYDATASOURCEPACKAGE_BINDING);
            protocolMarshaller.marshall(memberDetail.getDatasourcePackageIngestStates(), DATASOURCEPACKAGEINGESTSTATES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

